/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util;

import com.tc.net.EphemeralPorts;
import com.tc.util.Assert;
import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;

public final class PortChooser {
    public static final int MAX = 65535;
    private static final Object VM_WIDE_LOCK = (PortChooser.class.getName() + "LOCK").intern();
    private static final Set<Integer> chosen = new HashSet<Integer>();
    private static final Random random = new Random();
    private static final EphemeralPorts.Range exclude = EphemeralPorts.getRange();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int chooseRandomPort() {
        Object object = VM_WIDE_LOCK;
        synchronized (object) {
            int portNum = this.choose();
            Assert.assertTrue(chosen.add(portNum));
            return portNum;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int chooseRandom2Port() {
        int port;
        Object object = VM_WIDE_LOCK;
        synchronized (object) {
            while ((port = this.choose()) + 1 >= 65535 || this.isPortUsed(port + 1)) {
            }
            Assert.assertTrue(chosen.add(port));
            Assert.assertTrue(chosen.add(port + 1));
        }
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int chooseRandomPorts(int numOfPorts) {
        Assert.assertTrue(numOfPorts > 0);
        int port = 0;
        Object object = VM_WIDE_LOCK;
        synchronized (object) {
            while (true) {
                if ((port = this.choose()) + numOfPorts > 65535) {
                    continue;
                }
                boolean isChosen = true;
                for (int i = 1; i < numOfPorts; ++i) {
                    if (!this.isPortUsed(port + i)) continue;
                    isChosen = false;
                    break;
                }
                if (isChosen && port + numOfPorts <= 65535) break;
            }
            for (int i = 0; i < numOfPorts; ++i) {
                Assert.assertTrue(chosen.add(port + i));
            }
        }
        return port;
    }

    public boolean isPortUsed(int portNum) {
        Integer port = portNum;
        if (chosen.contains(port)) {
            return true;
        }
        return !this.canBind(portNum) && !this.canConnect(portNum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canConnect(int portNumber) {
        Socket sock = null;
        boolean isFree = false;
        try {
            sock = new Socket("localhost", portNumber);
            isFree = false;
        }
        catch (IOException e) {
            isFree = true;
        }
        finally {
            if (sock != null) {
                try {
                    sock.close();
                }
                catch (IOException e) {}
            }
        }
        return isFree;
    }

    private boolean canBind(int portNum) {
        if (exclude.isInRange(portNum)) {
            return false;
        }
        ServerSocket ss = null;
        boolean isFree = false;
        try {
            ss = new ServerSocket(portNum);
            isFree = true;
        }
        catch (BindException be) {
            isFree = false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException e) {}
            }
        }
        return isFree;
    }

    private synchronized int choose() {
        int attempt;
        while (chosen.contains(attempt = PortChooser.getNonEphemeralPort()) || !this.canBind(attempt) || !this.canConnect(attempt)) {
        }
        return attempt;
    }

    private static int getNonEphemeralPort() {
        int p;
        while (exclude.isInRange(p = random.nextInt(64511) + 1024)) {
        }
        return p;
    }
}

