/*
 * Decompiled with CFR 0.152.
 */
package com.tc.config.schema.setup;

import com.tc.config.schema.setup.ClientConfigurationSetupManager;
import com.tc.config.schema.setup.ConfigurationSetupException;
import com.tc.config.schema.setup.L1ConfigurationSetupManager;
import com.tc.net.core.SecurityInfo;
import com.tc.security.PwProvider;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientConfigurationSetupManagerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientConfigurationSetupManagerFactory.class);
    private static final Pattern SERVER_PATTERN = Pattern.compile("(.*):(.*)", 2);
    private final String[] args;
    private final List<String> stripeMemberUris;
    private final PwProvider securityManager;

    public ClientConfigurationSetupManagerFactory(String[] args, List<String> stripeMemberUris, PwProvider securityManager) {
        this.args = args;
        this.stripeMemberUris = stripeMemberUris;
        this.securityManager = securityManager;
    }

    public L1ConfigurationSetupManager getL1TVSConfigurationSetupManager(SecurityInfo securityInfo) throws ConfigurationSetupException {
        int memberCount = this.stripeMemberUris.size();
        String[] hosts = new String[memberCount];
        int[] ports = new int[memberCount];
        int index = 0;
        for (String stripeMemberUri : this.stripeMemberUris) {
            String host;
            Matcher matcher = SERVER_PATTERN.matcher(stripeMemberUri);
            if (matcher.matches()) {
                host = matcher.group(1);
                int userSeparatorIndex = host.indexOf(64);
                if (userSeparatorIndex > -1) {
                    host = host.substring(userSeparatorIndex + 1);
                }
            } else {
                String errMsg = "Invalid configuration URL: " + stripeMemberUri;
                LOGGER.error(errMsg);
                throw new ConfigurationSetupException(errMsg);
            }
            int port = Integer.parseInt(matcher.group(2));
            hosts[index] = host;
            ports[index] = port;
            ++index;
        }
        return new ClientConfigurationSetupManager(this.stripeMemberUris, this.args, hosts, ports, securityInfo);
    }
}

