/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.core;

import com.tc.logging.LossyTCLogger;
import com.tc.net.core.CoreNIOServices;
import com.tc.net.core.SocketParams;
import com.tc.util.Assert;
import com.tc.util.concurrent.SetOnceFlag;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCWorkerCommManager {
    private static final Logger logger = LoggerFactory.getLogger(TCWorkerCommManager.class);
    private static final LossyTCLogger lossyLogger = new LossyTCLogger(logger, 10L, LossyTCLogger.LossyTCLoggerType.COUNT_BASED, false);
    private static final String WORKER_NAME_PREFIX = "TCWorkerComm # ";
    private final int totalWorkerComm;
    private final CoreNIOServices[] workerCommThreads;
    private final SetOnceFlag started = new SetOnceFlag();
    private final SetOnceFlag stopped = new SetOnceFlag();

    TCWorkerCommManager(String name, int workerCommCount, SocketParams socketParams) {
        if (workerCommCount <= 0) {
            throw new IllegalArgumentException("invalid worker count: " + workerCommCount);
        }
        logger.info("Creating " + workerCommCount + " worker comm threads for " + name);
        this.totalWorkerComm = workerCommCount;
        this.workerCommThreads = new CoreNIOServices[workerCommCount];
        for (int i = 0; i < this.workerCommThreads.length; ++i) {
            this.workerCommThreads[i] = new CoreNIOServices(name + ":" + WORKER_NAME_PREFIX + i, this, socketParams);
        }
    }

    public CoreNIOServices getNextWorkerComm() {
        CoreNIOServices leastWeightWorkerComm = null;
        while (leastWeightWorkerComm == null) {
            leastWeightWorkerComm = this.getLeastWeightWorkerComm();
        }
        Assert.assertTrue(null != leastWeightWorkerComm);
        String message = "Selecting " + leastWeightWorkerComm + "  from " + Arrays.asList(this.workerCommThreads);
        if (logger.isDebugEnabled()) {
            logger.debug(message);
        }
        return leastWeightWorkerComm;
    }

    private CoreNIOServices getLeastWeightWorkerComm() {
        CoreNIOServices selectedWorkerComm = null;
        for (CoreNIOServices workerComm : this.workerCommThreads) {
            if (!workerComm.compareWeights(selectedWorkerComm)) continue;
            selectedWorkerComm = workerComm;
        }
        return selectedWorkerComm;
    }

    public synchronized void start() {
        if (this.started.attemptSet()) {
            for (CoreNIOServices workerCommThread : this.workerCommThreads) {
                workerCommThread.start();
            }
        } else {
            throw new IllegalStateException("already started");
        }
    }

    public synchronized void stop() {
        if (!this.started.isSet()) {
            return;
        }
        if (this.stopped.attemptSet()) {
            for (int i = 0; i < this.totalWorkerComm; ++i) {
                this.workerCommThreads[i].requestStop();
            }
        }
    }

    protected CoreNIOServices getWorkerComm(int workerCommId) {
        return this.workerCommThreads[workerCommId];
    }

    protected int getWeightForWorkerComm(int workerCommId) {
        return this.workerCommThreads[workerCommId].getWeight();
    }

    protected long getTotalBytesReadByWorkerComm(int workerCommId) {
        return this.workerCommThreads[workerCommId].getTotalBytesRead();
    }

    protected long getTotalBytesWrittenByWorkerComm(int workerCommId) {
        return this.workerCommThreads[workerCommId].getTotalBytesWritten();
    }
}

