/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.locks;

public enum LockLevel {
    READ,
    WRITE,
    SYNCHRONOUS_WRITE,
    CONCURRENT;

    public static final int READ_LEVEL = 1;
    public static final int WRITE_LEVEL = 2;
    public static final int SYNCHRONOUS_WRITE_LEVEL = 3;
    public static final int CONCURRENT_LEVEL = 4;

    public boolean isWrite() {
        switch (this) {
            case WRITE: 
            case SYNCHRONOUS_WRITE: {
                return true;
            }
        }
        return false;
    }

    public boolean isRead() {
        switch (this) {
            case READ: {
                return true;
            }
        }
        return false;
    }

    public boolean isSyncWrite() {
        return SYNCHRONOUS_WRITE.equals((Object)this);
    }

    public int toInt() {
        switch (this) {
            case READ: {
                return 1;
            }
            case WRITE: {
                return 2;
            }
            case SYNCHRONOUS_WRITE: {
                return 3;
            }
            case CONCURRENT: {
                return 4;
            }
        }
        throw new AssertionError((Object)"Enum semantics broken in LockLevel?");
    }

    public static LockLevel fromInt(int integer) {
        switch (integer) {
            case 1: {
                return READ;
            }
            case 2: {
                return WRITE;
            }
            case 3: {
                return SYNCHRONOUS_WRITE;
            }
            case 4: {
                return CONCURRENT;
            }
        }
        throw new IllegalArgumentException("Invalid integer lock level " + integer);
    }
}

