/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.tcm;

import com.tc.async.api.Sink;
import com.tc.net.protocol.tcm.TCMessage;
import com.tc.net.protocol.tcm.TCMessageRouter;
import com.tc.net.protocol.tcm.TCMessageSink;
import com.tc.net.protocol.tcm.TCMessageSinkToSedaSink;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.net.protocol.tcm.UnsupportedMessageTypeException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCMessageRouterImpl
implements TCMessageRouter {
    private static final Logger logger = LoggerFactory.getLogger(TCMessageRouter.class);
    private final Map<TCMessageType, TCMessageSink> routesByType = new ConcurrentHashMap<TCMessageType, TCMessageSink>();
    private final TCMessageSink defaultRoute;

    public TCMessageRouterImpl() {
        this(null);
    }

    public TCMessageRouterImpl(TCMessageSink defRoute) {
        this.defaultRoute = null == defRoute ? new TCMessageSink(){

            @Override
            public void putMessage(TCMessage message) throws UnsupportedMessageTypeException {
                throw new UnsupportedMessageTypeException(message.getMessageType());
            }
        } : defRoute;
    }

    @Override
    public void putMessage(TCMessage msg) {
        TCMessageSink route;
        boolean debug = logger.isDebugEnabled();
        if (debug) {
            logger.debug("Received a message: " + msg.toString());
        }
        if ((route = this.routesByType.get(msg.getMessageType())) != null) {
            if (debug) {
                logger.debug(msg.getMessageType().toString() + " message being routed by message type");
            }
            route.putMessage(msg);
        } else {
            this.defaultRoute.putMessage(msg);
        }
    }

    @Override
    public void routeMessageType(TCMessageType type, TCMessageSink sink) {
        if (null == sink) {
            throw new IllegalArgumentException("Sink cannot be null");
        }
        this.routesByType.put(type, sink);
    }

    @Override
    public void routeMessageType(TCMessageType messageType, Sink destSink, Sink hydrateSink) {
        this.routeMessageType(messageType, new TCMessageSinkToSedaSink(destSink, hydrateSink));
    }

    @Override
    public void unrouteMessageType(TCMessageType type) {
        this.routesByType.remove(type);
    }
}

