/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.dna.impl;

import com.tc.io.TCDataInput;
import com.tc.io.TCDataOutput;
import com.tc.object.LiteralValues;
import com.tc.object.ObjectID;
import com.tc.object.compression.CompressedData;
import com.tc.object.compression.StringCompressionUtil;
import com.tc.object.dna.api.DNAEncodingInternal;
import com.tc.object.dna.impl.ClassInstance;
import com.tc.object.dna.impl.EnumInstance;
import com.tc.object.dna.impl.NullObjectStringSerializer;
import com.tc.object.dna.impl.ObjectStringSerializer;
import com.tc.object.dna.impl.StringCompressionConfig;
import com.tc.object.dna.impl.UTF8ByteCompressedDataHolder;
import com.tc.object.dna.impl.UTF8ByteDataHolder;
import com.tc.object.loaders.ClassProvider;
import com.tc.util.Assert;
import com.tc.util.ServiceUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.InflaterInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDNAEncodingImpl
implements DNAEncodingInternal {
    private static final int WARN_THRESHOLD = 8000000;
    private static final int BOOLEAN_WARN = 8000000;
    private static final int BYTE_WARN = 8000000;
    private static final int CHAR_WARN = 4000000;
    private static final int DOUBLE_WARN = 1000000;
    private static final int FLOAT_WARN = 2000000;
    private static final int INT_WARN = 2000000;
    private static final int LONG_WARN = 1000000;
    private static final int SHORT_WARN = 4000000;
    private static final int REF_WARN = 2000000;
    static final byte LOGICAL_ACTION_TYPE = 1;
    static final byte PHYSICAL_ACTION_TYPE = 2;
    static final byte ARRAY_ELEMENT_ACTION_TYPE = 3;
    static final byte ENTIRE_ARRAY_ACTION_TYPE = 4;
    static final byte LITERAL_VALUE_ACTION_TYPE = 5;
    static final byte PHYSICAL_ACTION_TYPE_REF_OBJECT = 6;
    static final byte SUB_ARRAY_ACTION_TYPE = 7;
    private static final Logger logger = LoggerFactory.getLogger(BaseDNAEncodingImpl.class);
    protected static final byte TYPE_ID_REFERENCE = 1;
    protected static final byte TYPE_ID_BOOLEAN = 2;
    protected static final byte TYPE_ID_BYTE = 3;
    protected static final byte TYPE_ID_CHAR = 4;
    protected static final byte TYPE_ID_DOUBLE = 5;
    protected static final byte TYPE_ID_FLOAT = 6;
    protected static final byte TYPE_ID_INT = 7;
    protected static final byte TYPE_ID_LONG = 10;
    protected static final byte TYPE_ID_SHORT = 11;
    protected static final byte TYPE_ID_STRING = 12;
    protected static final byte TYPE_ID_STRING_BYTES = 13;
    protected static final byte TYPE_ID_ARRAY = 14;
    protected static final byte TYPE_ID_JAVA_LANG_CLASS = 15;
    protected static final byte TYPE_ID_JAVA_LANG_CLASS_HOLDER = 16;
    protected static final byte TYPE_ID_ENUM = 22;
    protected static final byte TYPE_ID_ENUM_HOLDER = 23;
    protected static final byte TYPE_ID_STRING_COMPRESSED = 25;
    private static final byte ARRAY_TYPE_PRIMITIVE = 1;
    private static final byte ARRAY_TYPE_NON_PRIMITIVE = 2;
    private static final boolean STRING_COMPRESSION_ENABLED;
    protected static final boolean STRING_COMPRESSION_LOGGING_ENABLED;
    private static final int STRING_COMPRESSION_MIN_SIZE;
    private static final ObjectStringSerializer NULL_SERIALIZER;
    protected final ClassProvider classProvider;
    private static final Map<Object, Byte> primitiveClassMap;

    public BaseDNAEncodingImpl(ClassProvider classProvider) {
        this.classProvider = classProvider;
    }

    @Override
    public void encode(Object value, TCDataOutput output) {
        this.encode(value, output, NULL_SERIALIZER);
    }

    @Override
    public void encode(Object value, TCDataOutput output, ObjectStringSerializer serializer) {
        if (value == null) {
            value = ObjectID.NULL_ID;
        }
        LiteralValues type = LiteralValues.valueFor(value);
        switch (type) {
            case ENUM: {
                output.writeByte(22);
                Class enumClass = ((Enum)value).getDeclaringClass();
                this.writeString(enumClass.getName(), output, serializer);
                this.writeString(((Enum)value).name(), output, serializer);
                break;
            }
            case ENUM_HOLDER: {
                output.writeByte(23);
                this.writeEnumInstance((EnumInstance)value, output, serializer);
                break;
            }
            case JAVA_LANG_CLASS: {
                output.writeByte(15);
                Class c = (Class)value;
                this.writeString(c.getName(), output, serializer);
                break;
            }
            case JAVA_LANG_CLASS_HOLDER: {
                output.writeByte(16);
                this.writeClassInstance((ClassInstance)value, output, serializer);
                break;
            }
            case BOOLEAN: {
                output.writeByte(2);
                output.writeBoolean((Boolean)value);
                break;
            }
            case BYTE: {
                output.writeByte(3);
                output.writeByte(((Byte)value).byteValue());
                break;
            }
            case CHARACTER: {
                output.writeByte(4);
                output.writeChar(((Character)value).charValue());
                break;
            }
            case DOUBLE: {
                output.writeByte(5);
                output.writeDouble((Double)value);
                break;
            }
            case FLOAT: {
                output.writeByte(6);
                output.writeFloat(((Float)value).floatValue());
                break;
            }
            case INTEGER: {
                output.writeByte(7);
                output.writeInt((Integer)value);
                break;
            }
            case LONG: {
                output.writeByte(10);
                output.writeLong((Long)value);
                break;
            }
            case SHORT: {
                output.writeByte(11);
                output.writeShort(((Short)value).shortValue());
                break;
            }
            case STRING: {
                String s = (String)value;
                if (STRING_COMPRESSION_ENABLED && s.length() >= STRING_COMPRESSION_MIN_SIZE) {
                    output.writeByte(25);
                    this.writeCompressedString(s, output);
                    break;
                }
                output.writeByte(12);
                this.writeString(s, output, serializer);
                break;
            }
            case STRING_BYTES: {
                UTF8ByteDataHolder utfBytes = (UTF8ByteDataHolder)value;
                output.writeByte(13);
                serializer.writeStringBytes(output, utfBytes.getBytes());
                break;
            }
            case STRING_BYTES_COMPRESSED: {
                UTF8ByteCompressedDataHolder utfCompressedBytes = (UTF8ByteCompressedDataHolder)value;
                output.writeByte(25);
                output.writeInt(utfCompressedBytes.getUncompressedStringLength());
                this.writeByteArray(utfCompressedBytes.getBytes(), output);
                output.writeInt(utfCompressedBytes.getStringLength());
                output.writeInt(utfCompressedBytes.getStringHash());
                break;
            }
            case OBJECT_ID: {
                output.writeByte(1);
                output.writeLong(((ObjectID)value).toLong());
                break;
            }
            case ARRAY: {
                this.encodeArray(value, output);
                break;
            }
            default: {
                throw Assert.failure("Illegal type (" + (Object)((Object)type) + "):" + value);
            }
        }
    }

    private void writeEnumInstance(EnumInstance value, TCDataOutput output, ObjectStringSerializer serializer) {
        this.writeStringBytes(value.getClassInstance().getName().getBytes(), output, serializer);
        this.writeStringBytes(value.getEnumName().getBytes(), output, serializer);
    }

    private void writeClassInstance(ClassInstance value, TCDataOutput output, ObjectStringSerializer serializer) {
        this.writeStringBytes(value.getName().getBytes(), output, serializer);
    }

    private void writeString(String string, TCDataOutput output, ObjectStringSerializer serializer) {
        try {
            this.writeStringBytes(string.getBytes("UTF-8"), output, serializer);
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void writeStringBytes(byte[] bytes, TCDataOutput output, ObjectStringSerializer serializer) {
        serializer.writeStringBytes(output, bytes);
    }

    private void writeCompressedString(String string, TCDataOutput output) {
        byte[] uncompressed = StringCompressionUtil.stringToUncompressedBin(string);
        CompressedData compressedInfo = StringCompressionUtil.compressBin(uncompressed);
        byte[] compressed = compressedInfo.getCompressedData();
        int compressedSize = compressedInfo.getCompressedSize();
        output.writeInt(uncompressed.length);
        this.writeByteArray(compressed, 0, compressedSize, output);
        output.writeInt(string.length());
        output.writeInt(string.hashCode());
        if (STRING_COMPRESSION_LOGGING_ENABLED) {
            logger.info("Compressed String of size : " + string.length() + " bytes : " + uncompressed.length + " to  bytes : " + compressed.length);
        }
    }

    private void writeByteArray(byte[] bytes, int offset, int length, TCDataOutput output) {
        output.writeInt(length);
        output.write(bytes, offset, length);
    }

    private void writeByteArray(byte[] bytes, TCDataOutput output) {
        output.writeInt(bytes.length);
        output.write(bytes);
    }

    protected byte[] readByteArray(TCDataInput input) throws IOException {
        int length = input.readInt();
        if (length >= 8000000) {
            logger.warn("Attempting to allocate a large byte array of size: " + length);
        }
        byte[] array = new byte[length];
        input.readFully(array);
        return array;
    }

    @Override
    public Object decode(TCDataInput input) throws IOException, ClassNotFoundException {
        return this.decode(input, NULL_SERIALIZER);
    }

    @Override
    public Object decode(TCDataInput input, ObjectStringSerializer serializer) throws IOException, ClassNotFoundException {
        byte type = input.readByte();
        switch (type) {
            case 22: {
                return this.readEnum(input, type, serializer);
            }
            case 23: {
                return this.readEnum(input, type, serializer);
            }
            case 15: {
                return this.readClass(input, type, serializer);
            }
            case 16: {
                return this.readClass(input, type, serializer);
            }
            case 2: {
                return input.readBoolean();
            }
            case 3: {
                return input.readByte();
            }
            case 4: {
                return Character.valueOf(input.readChar());
            }
            case 5: {
                return input.readDouble();
            }
            case 6: {
                return Float.valueOf(input.readFloat());
            }
            case 7: {
                return input.readInt();
            }
            case 10: {
                return input.readLong();
            }
            case 11: {
                return input.readShort();
            }
            case 12: {
                return this.readString(input, type, serializer);
            }
            case 25: {
                return this.readCompressedString(input);
            }
            case 13: {
                return this.readString(input, type, serializer);
            }
            case 1: {
                return new ObjectID(input.readLong());
            }
            case 14: {
                return this.decodeArray(input);
            }
        }
        throw Assert.failure("Illegal type (" + type + ")");
    }

    @Override
    public void encodeArray(Object value, TCDataOutput output) {
        this.encodeArray(value, output, value == null ? -1 : Array.getLength(value));
    }

    @Override
    public void encodeArray(Object value, TCDataOutput output, int length) {
        block12: {
            block11: {
                output.writeByte(14);
                if (value == null) {
                    output.writeInt(-1);
                    return;
                }
                output.writeInt(length);
                Class<?> type = value.getClass().getComponentType();
                if (!type.isPrimitive()) break block11;
                output.writeByte(1);
                switch (primitiveClassMap.get(type)) {
                    case 2: {
                        this.encodeBooleanArray((boolean[])value, output, length);
                        break block12;
                    }
                    case 3: {
                        this.encodeByteArray((byte[])value, output, length);
                        break block12;
                    }
                    case 4: {
                        this.encodeCharArray((char[])value, output, length);
                        break block12;
                    }
                    case 11: {
                        this.encodeShortArray((short[])value, output, length);
                        break block12;
                    }
                    case 7: {
                        this.encodeIntArray((int[])value, output, length);
                        break block12;
                    }
                    case 10: {
                        this.encodeLongArray((long[])value, output, length);
                        break block12;
                    }
                    case 6: {
                        this.encodeFloatArray((float[])value, output, length);
                        break block12;
                    }
                    case 5: {
                        this.encodeDoubleArray((double[])value, output, length);
                        break block12;
                    }
                    default: {
                        throw Assert.failure("unknown primitive array type: " + type);
                    }
                }
            }
            output.writeByte(2);
            this.encodeObjectArray((Object[])value, output, length);
        }
    }

    private void encodeByteArray(byte[] value, TCDataOutput output, int length) {
        output.writeByte(3);
        output.write(value, 0, length);
    }

    private void encodeObjectArray(Object[] value, TCDataOutput output, int length) {
        for (int i = 0; i < length; ++i) {
            this.encode(value[i], output);
        }
    }

    private void encodeDoubleArray(double[] value, TCDataOutput output, int length) {
        output.writeByte(5);
        for (int i = 0; i < length; ++i) {
            output.writeDouble(value[i]);
        }
    }

    private void encodeFloatArray(float[] value, TCDataOutput output, int length) {
        output.writeByte(6);
        for (int i = 0; i < length; ++i) {
            output.writeFloat(value[i]);
        }
    }

    private void encodeLongArray(long[] value, TCDataOutput output, int length) {
        output.writeByte(10);
        for (int i = 0; i < length; ++i) {
            output.writeLong(value[i]);
        }
    }

    private void encodeIntArray(int[] value, TCDataOutput output, int length) {
        output.writeByte(7);
        for (int i = 0; i < length; ++i) {
            output.writeInt(value[i]);
        }
    }

    private void encodeShortArray(short[] value, TCDataOutput output, int length) {
        output.writeByte(11);
        for (int i = 0; i < length; ++i) {
            output.writeShort(value[i]);
        }
    }

    private void encodeCharArray(char[] value, TCDataOutput output, int length) {
        output.writeByte(4);
        for (int i = 0; i < length; ++i) {
            output.writeChar(value[i]);
        }
    }

    private void encodeBooleanArray(boolean[] value, TCDataOutput output, int length) {
        output.writeByte(2);
        for (int i = 0; i < length; ++i) {
            output.writeBoolean(value[i]);
        }
    }

    private void checkSize(Class<?> type, int threshold, int len) {
        if (len >= threshold) {
            logger.warn("Attempt to read a " + type + " array of len: " + len + "; threshold=" + threshold);
        }
    }

    private Object decodeArray(TCDataInput input) throws IOException, ClassNotFoundException {
        int len = input.readInt();
        if (len < 0) {
            return null;
        }
        byte arrayType = input.readByte();
        switch (arrayType) {
            case 1: {
                return this.decodePrimitiveArray(len, input);
            }
            case 2: {
                return this.decodeNonPrimitiveArray(len, input);
            }
        }
        throw Assert.failure("unknown array type: " + arrayType);
    }

    private Object[] decodeNonPrimitiveArray(int len, TCDataInput input) throws IOException, ClassNotFoundException {
        this.checkSize(Object.class, 2000000, len);
        Object[] rv = new Object[len];
        int n = rv.length;
        for (int i = 0; i < n; ++i) {
            rv[i] = this.decode(input);
        }
        return rv;
    }

    private Object decodePrimitiveArray(int len, TCDataInput input) throws IOException {
        byte type = input.readByte();
        switch (type) {
            case 2: {
                this.checkSize(Boolean.TYPE, 8000000, len);
                return this.decodeBooleanArray(len, input);
            }
            case 3: {
                this.checkSize(Byte.TYPE, 8000000, len);
                return this.decodeByteArray(len, input);
            }
            case 4: {
                this.checkSize(Character.TYPE, 4000000, len);
                return this.decodeCharArray(len, input);
            }
            case 5: {
                this.checkSize(Double.TYPE, 1000000, len);
                return this.decodeDoubleArray(len, input);
            }
            case 6: {
                this.checkSize(Float.TYPE, 2000000, len);
                return this.decodeFloatArray(len, input);
            }
            case 7: {
                this.checkSize(Integer.TYPE, 2000000, len);
                return this.decodeIntArray(len, input);
            }
            case 10: {
                this.checkSize(Long.TYPE, 1000000, len);
                return this.decodeLongArray(len, input);
            }
            case 11: {
                this.checkSize(Short.TYPE, 4000000, len);
                return this.decodeShortArray(len, input);
            }
        }
        throw Assert.failure("unknown prim type: " + type);
    }

    private short[] decodeShortArray(int len, TCDataInput input) throws IOException {
        short[] rv = new short[len];
        int n = rv.length;
        for (int i = 0; i < n; ++i) {
            rv[i] = input.readShort();
        }
        return rv;
    }

    private long[] decodeLongArray(int len, TCDataInput input) throws IOException {
        long[] rv = new long[len];
        int n = rv.length;
        for (int i = 0; i < n; ++i) {
            rv[i] = input.readLong();
        }
        return rv;
    }

    private int[] decodeIntArray(int len, TCDataInput input) throws IOException {
        int[] rv = new int[len];
        int n = rv.length;
        for (int i = 0; i < n; ++i) {
            rv[i] = input.readInt();
        }
        return rv;
    }

    private float[] decodeFloatArray(int len, TCDataInput input) throws IOException {
        float[] rv = new float[len];
        int n = rv.length;
        for (int i = 0; i < n; ++i) {
            rv[i] = input.readFloat();
        }
        return rv;
    }

    private double[] decodeDoubleArray(int len, TCDataInput input) throws IOException {
        double[] rv = new double[len];
        int n = rv.length;
        for (int i = 0; i < n; ++i) {
            rv[i] = input.readDouble();
        }
        return rv;
    }

    private char[] decodeCharArray(int len, TCDataInput input) throws IOException {
        char[] rv = new char[len];
        int n = rv.length;
        for (int i = 0; i < n; ++i) {
            rv[i] = input.readChar();
        }
        return rv;
    }

    private byte[] decodeByteArray(int len, TCDataInput input) throws IOException {
        int read;
        byte[] rv = new byte[len];
        if (len != 0 && (read = input.read(rv, 0, len)) != len) {
            throw new IOException("read " + read + " bytes, expected " + len);
        }
        return rv;
    }

    private boolean[] decodeBooleanArray(int len, TCDataInput input) throws IOException {
        boolean[] rv = new boolean[len];
        int n = rv.length;
        for (int i = 0; i < n; ++i) {
            rv[i] = input.readBoolean();
        }
        return rv;
    }

    private Object readEnum(TCDataInput input, byte type, ObjectStringSerializer serializer) throws IOException, ClassNotFoundException {
        UTF8ByteDataHolder name = new UTF8ByteDataHolder(this.readStringBytes(input, serializer));
        byte[] data = this.readStringBytes(input, serializer);
        if (this.useStringEnumRead(type)) {
            Class<?> enumType = new ClassInstance(name).asClass(this.classProvider);
            String enumName = new String(data, "UTF-8");
            return BaseDNAEncodingImpl.makeEnum(enumType, enumName);
        }
        ClassInstance clazzInstance = new ClassInstance(name);
        UTF8ByteDataHolder enumName = new UTF8ByteDataHolder(data);
        return new EnumInstance(clazzInstance, enumName);
    }

    private static Enum<?> makeEnum(Class<?> enumType, String enumName) {
        return Enum.valueOf(enumType, enumName);
    }

    protected abstract boolean useStringEnumRead(byte var1);

    protected abstract boolean useClassProvider(byte var1, byte var2);

    private Object readClass(TCDataInput input, byte type, ObjectStringSerializer serializer) throws IOException, ClassNotFoundException {
        UTF8ByteDataHolder name = new UTF8ByteDataHolder(this.readStringBytes(input, serializer));
        if (this.useClassProvider(type, (byte)15)) {
            return new ClassInstance(name).asClass(this.classProvider);
        }
        return new ClassInstance(name);
    }

    private Object readString(TCDataInput input, byte type, ObjectStringSerializer serializer) throws IOException {
        byte[] data = this.readStringBytes(input, serializer);
        if (this.useUTF8String(type)) {
            if (data.length == 0) {
                return "";
            }
            return new String(data, "UTF-8");
        }
        return new UTF8ByteDataHolder(data);
    }

    private byte[] readStringBytes(TCDataInput input, ObjectStringSerializer serializer) throws IOException {
        return serializer.readStringBytes(input);
    }

    protected abstract boolean useUTF8String(byte var1);

    protected Object readCompressedString(TCDataInput input) throws IOException {
        int stringUncompressedByteLength = input.readInt();
        byte[] data = this.readByteArray(input);
        int stringLength = input.readInt();
        int stringHash = input.readInt();
        return new UTF8ByteCompressedDataHolder(data, stringUncompressedByteLength, stringLength, stringHash);
    }

    public static String inflateCompressedString(byte[] data, int length) {
        try {
            int read;
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            InflaterInputStream iis = new InflaterInputStream(bais);
            byte[] uncompressed = new byte[length];
            int offset = 0;
            while (length > 0 && (read = iis.read(uncompressed, offset, length)) != -1) {
                offset += read;
                length -= read;
            }
            iis.close();
            Assert.assertEquals(0, length);
            return new String(uncompressed, "UTF-8");
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        NULL_SERIALIZER = new NullObjectStringSerializer();
        StringCompressionConfig config = ServiceUtil.loadService(StringCompressionConfig.class);
        STRING_COMPRESSION_ENABLED = config.enabled();
        STRING_COMPRESSION_LOGGING_ENABLED = config.loggingEnabled();
        STRING_COMPRESSION_MIN_SIZE = config.minSize();
        primitiveClassMap = new HashMap<Object, Byte>();
        primitiveClassMap.put(Boolean.TYPE, (byte)2);
        primitiveClassMap.put(Byte.TYPE, (byte)3);
        primitiveClassMap.put(Character.TYPE, (byte)4);
        primitiveClassMap.put(Double.TYPE, (byte)5);
        primitiveClassMap.put(Float.TYPE, (byte)6);
        primitiveClassMap.put(Integer.TYPE, (byte)7);
        primitiveClassMap.put(Long.TYPE, (byte)10);
        primitiveClassMap.put(Short.TYPE, (byte)11);
    }
}

