/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.delivery;

import com.tc.net.protocol.delivery.OOOProtocolMessage;
import com.tc.net.protocol.delivery.State;
import com.tc.util.Assert;

public abstract class AbstractStateMachine {
    private State current;
    private boolean started = false;
    private boolean paused = true;

    public abstract void execute(OOOProtocolMessage var1);

    public final synchronized boolean isStarted() {
        return this.started;
    }

    public final synchronized void start() {
        Assert.eval(!this.started);
        this.started = true;
        this.paused = true;
        this.switchToState(this.initialState());
    }

    public final synchronized void pause() {
        Assert.eval("started: " + this.started + ", paused: " + this.paused, this.started && !this.paused);
        this.basicPause();
        this.paused = true;
    }

    protected void basicPause() {
    }

    protected void basicResume() {
    }

    public final synchronized void resume() {
        Assert.eval("started: " + this.started + ", paused: " + this.paused, this.started && this.paused);
        this.paused = false;
        this.basicResume();
    }

    public final synchronized boolean isPaused() {
        return this.paused;
    }

    protected synchronized void switchToState(State state) {
        Assert.eval(state != null && this.isStarted());
        this.current = state;
        state.enter();
    }

    public final synchronized State getCurrentState() {
        return this.current;
    }

    protected abstract State initialState();

    public abstract void reset();

    public String toString() {
        return "Started: " + this.isStarted() + "; Paused: " + this.isPaused();
    }
}

