/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.tcm;

import com.tc.exception.TCRuntimeException;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.net.AddressChecker;
import com.tc.net.ServerID;
import com.tc.net.TCSocketAddress;
import com.tc.net.core.TCConnection;
import com.tc.net.core.TCConnectionManager;
import com.tc.net.core.TCConnectionManagerImpl;
import com.tc.net.core.TCListener;
import com.tc.net.core.security.TCSecurityManager;
import com.tc.net.protocol.NetworkStackHarness;
import com.tc.net.protocol.NetworkStackHarnessFactory;
import com.tc.net.protocol.tcm.ChannelID;
import com.tc.net.protocol.tcm.ChannelManagerImpl;
import com.tc.net.protocol.tcm.ClientMessageChannel;
import com.tc.net.protocol.tcm.ClientMessageChannelImpl;
import com.tc.net.protocol.tcm.CommunicationsManager;
import com.tc.net.protocol.tcm.GeneratedMessageFactory;
import com.tc.net.protocol.tcm.MessageChannelInternal;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.MessageTransportFactoryImpl;
import com.tc.net.protocol.tcm.NetworkListener;
import com.tc.net.protocol.tcm.NetworkListenerImpl;
import com.tc.net.protocol.tcm.ServerMessageChannelFactory;
import com.tc.net.protocol.tcm.ServerMessageChannelImpl;
import com.tc.net.protocol.tcm.TCMessage;
import com.tc.net.protocol.tcm.TCMessageFactory;
import com.tc.net.protocol.tcm.TCMessageFactoryImpl;
import com.tc.net.protocol.tcm.TCMessageRouter;
import com.tc.net.protocol.tcm.TCMessageRouterImpl;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.net.protocol.transport.ClientConnectionEstablisher;
import com.tc.net.protocol.transport.ConnectionHealthChecker;
import com.tc.net.protocol.transport.ConnectionHealthCheckerEchoImpl;
import com.tc.net.protocol.transport.ConnectionHealthCheckerImpl;
import com.tc.net.protocol.transport.ConnectionID;
import com.tc.net.protocol.transport.ConnectionIDFactory;
import com.tc.net.protocol.transport.ConnectionPolicy;
import com.tc.net.protocol.transport.DefaultConnectionIdFactory;
import com.tc.net.protocol.transport.DisabledHealthCheckerConfigImpl;
import com.tc.net.protocol.transport.HealthCheckerConfig;
import com.tc.net.protocol.transport.MessageTransport;
import com.tc.net.protocol.transport.MessageTransportFactory;
import com.tc.net.protocol.transport.MessageTransportListener;
import com.tc.net.protocol.transport.NullConnectionIDFactoryImpl;
import com.tc.net.protocol.transport.ReconnectionRejectedHandler;
import com.tc.net.protocol.transport.ReconnectionRejectedHandlerL1;
import com.tc.net.protocol.transport.ReconnectionRejectedHandlerL2;
import com.tc.net.protocol.transport.ServerMessageTransport;
import com.tc.net.protocol.transport.ServerStackProvider;
import com.tc.net.protocol.transport.TransportHandshakeErrorHandler;
import com.tc.net.protocol.transport.TransportHandshakeErrorHandlerForL1;
import com.tc.net.protocol.transport.TransportHandshakeMessageFactory;
import com.tc.net.protocol.transport.TransportMessageFactoryImpl;
import com.tc.net.protocol.transport.WireProtocolAdaptorFactoryImpl;
import com.tc.net.protocol.transport.WireProtocolMessageSink;
import com.tc.object.session.NullSessionManager;
import com.tc.object.session.SessionManager;
import com.tc.object.session.SessionProvider;
import com.tc.operatorevent.NodeNameProvider;
import com.tc.util.Assert;
import com.tc.util.ProductID;
import com.tc.util.concurrent.SetOnceFlag;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

public class CommunicationsManagerImpl
implements CommunicationsManager {
    private static final TCLogger logger = TCLogging.getLogger(CommunicationsManager.class);
    private final SetOnceFlag shutdown = new SetOnceFlag();
    private final Set<NetworkListener> listeners = new HashSet<NetworkListener>();
    private final ReentrantLock licenseLock = new ReentrantLock();
    private final TCConnectionManager connectionManager;
    private final boolean privateConnMgr;
    private final NetworkStackHarnessFactory stackHarnessFactory;
    private final TransportHandshakeMessageFactory transportMessageFactory;
    private final MessageMonitor monitor;
    private final TCMessageRouter messageRouter;
    private final HealthCheckerConfig healthCheckerConfig;
    private final ConnectionPolicy connectionPolicy;
    private final ReconnectionRejectedHandler reconnectionRejectedHandler;
    protected final ProductID productId;
    protected final ConcurrentHashMap<TCMessageType, Class<? extends TCMessage>> messageTypeClassMapping = new ConcurrentHashMap();
    protected final ConcurrentHashMap<TCMessageType, GeneratedMessageFactory> messageTypeFactoryMapping = new ConcurrentHashMap();
    private ConnectionHealthChecker connectionHealthChecker;
    private ServerID serverID = ServerID.NULL_ID;
    private int callbackPort = -1;
    private NetworkListener callbackportListener = null;
    private final TransportHandshakeErrorHandler handshakeErrHandler;
    private final String commsMgrName;
    private final TCSecurityManager securityManager;
    private final SessionManager sessionManager = new NullSessionManager();

    public CommunicationsManagerImpl(String commsMgrName, MessageMonitor monitor, NetworkStackHarnessFactory stackHarnessFactory, ConnectionPolicy connectionPolicy) {
        this(commsMgrName, monitor, (TCMessageRouter)new TCMessageRouterImpl(), stackHarnessFactory, null, connectionPolicy, 0, new DisabledHealthCheckerConfigImpl(), (TransportHandshakeErrorHandler)new TransportHandshakeErrorHandlerForL1(), Collections.emptyMap(), Collections.emptyMap(), null);
    }

    public CommunicationsManagerImpl(String commsMgrName, MessageMonitor monitor, NetworkStackHarnessFactory stackHarnessFactory, ConnectionPolicy connectionPolicy, int workerCommCount) {
        this(commsMgrName, monitor, (TCMessageRouter)new TCMessageRouterImpl(), stackHarnessFactory, null, connectionPolicy, workerCommCount, new DisabledHealthCheckerConfigImpl(), (TransportHandshakeErrorHandler)new TransportHandshakeErrorHandlerForL1(), Collections.emptyMap(), Collections.emptyMap(), null);
    }

    public CommunicationsManagerImpl(String commsMgrName, MessageMonitor monitor, NetworkStackHarnessFactory stackHarnessFactory, ConnectionPolicy connectionPolicy, HealthCheckerConfig config) {
        this(commsMgrName, monitor, new TCMessageRouterImpl(), stackHarnessFactory, connectionPolicy, config, Collections.emptyMap(), Collections.emptyMap());
    }

    public CommunicationsManagerImpl(String commsMgrName, MessageMonitor monitor, TCMessageRouter messageRouter, NetworkStackHarnessFactory stackHarnessFactory, ConnectionPolicy connectionPolicy, HealthCheckerConfig config, Map<TCMessageType, Class<? extends TCMessage>> messageTypeClassMapping, Map<TCMessageType, GeneratedMessageFactory> messageTypeFactoryMapping) {
        this(commsMgrName, monitor, messageRouter, stackHarnessFactory, null, connectionPolicy, 0, config, (TransportHandshakeErrorHandler)new TransportHandshakeErrorHandlerForL1(), messageTypeClassMapping, messageTypeFactoryMapping, null);
    }

    public CommunicationsManagerImpl(String commsMgrName, MessageMonitor monitor, TCMessageRouter messageRouter, NetworkStackHarnessFactory stackHarnessFactory, ConnectionPolicy connectionPolicy, int workerCommCount, HealthCheckerConfig config, ServerID serverID, TransportHandshakeErrorHandler transportHandshakeErrorHandler, Map<TCMessageType, Class<? extends TCMessage>> messageTypeClassMapping, Map<TCMessageType, GeneratedMessageFactory> messageTypeFactoryMapping, TCSecurityManager securityManager) {
        this(commsMgrName, monitor, messageRouter, stackHarnessFactory, null, connectionPolicy, workerCommCount, config, transportHandshakeErrorHandler, messageTypeClassMapping, ReconnectionRejectedHandlerL2.SINGLETON, securityManager, null);
        this.serverID = serverID;
    }

    public CommunicationsManagerImpl(String commsMgrName, MessageMonitor monitor, TCMessageRouter messageRouter, NetworkStackHarnessFactory stackHarnessFactory, TCConnectionManager connMgr, ConnectionPolicy connectionPolicy, int workerCommCount, HealthCheckerConfig healthCheckerConf, TransportHandshakeErrorHandler transportHandshakeErrorHandler, Map<TCMessageType, Class<? extends TCMessage>> messageTypeClassMapping, Map<TCMessageType, GeneratedMessageFactory> messageTypeFactoryMapping, TCSecurityManager securityManager) {
        this(commsMgrName, monitor, messageRouter, stackHarnessFactory, connMgr, connectionPolicy, workerCommCount, healthCheckerConf, transportHandshakeErrorHandler, messageTypeClassMapping, ReconnectionRejectedHandlerL1.SINGLETON, securityManager, null);
    }

    public CommunicationsManagerImpl(String commsMgrName, MessageMonitor monitor, TCMessageRouter messageRouter, NetworkStackHarnessFactory stackHarnessFactory, TCConnectionManager connMgr, ConnectionPolicy connectionPolicy, int workerCommCount, HealthCheckerConfig healthCheckerConf, TransportHandshakeErrorHandler transportHandshakeErrorHandler, Map<TCMessageType, Class<? extends TCMessage>> messageTypeClassMapping, ReconnectionRejectedHandler reconnectionRejectedHandler, TCSecurityManager securityManager, ProductID productId) {
        this.commsMgrName = commsMgrName;
        this.monitor = monitor;
        this.messageRouter = messageRouter;
        this.productId = productId;
        this.transportMessageFactory = new TransportMessageFactoryImpl();
        this.connectionPolicy = connectionPolicy;
        this.stackHarnessFactory = stackHarnessFactory;
        this.healthCheckerConfig = healthCheckerConf;
        this.handshakeErrHandler = transportHandshakeErrorHandler;
        this.privateConnMgr = connMgr == null;
        this.messageTypeClassMapping.putAll(messageTypeClassMapping);
        this.messageTypeFactoryMapping.putAll(this.messageTypeFactoryMapping);
        this.reconnectionRejectedHandler = reconnectionRejectedHandler;
        this.securityManager = securityManager;
        Assert.assertNotNull(commsMgrName);
        this.connectionManager = null == connMgr ? new TCConnectionManagerImpl(commsMgrName, workerCommCount, this.healthCheckerConfig, securityManager) : connMgr;
        Assert.eval(this.healthCheckerConfig != null);
        this.connectionHealthChecker = this.healthCheckerConfig.isHealthCheckerEnabled() ? new ConnectionHealthCheckerImpl(this.healthCheckerConfig, this.connectionManager) : new ConnectionHealthCheckerEchoImpl();
        this.connectionHealthChecker.start();
        this.startHealthCheckCallbackPortListener(this.healthCheckerConfig);
    }

    @Override
    public TCConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    @Override
    public boolean isInShutdown() {
        return this.shutdown.isSet();
    }

    @Override
    public void shutdown() {
        if (this.shutdown.attemptSet()) {
            this.connectionHealthChecker.stop();
            if (this.privateConnMgr) {
                this.connectionManager.shutdown();
            }
        } else {
            logger.warn("shutdown already started");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetworkListener[] getAllListeners() {
        Set<NetworkListener> set = this.listeners;
        synchronized (set) {
            return this.listeners.toArray(new NetworkListener[this.listeners.size()]);
        }
    }

    @Override
    public void addClassMapping(TCMessageType messageType, Class<? extends TCMessage> messageClass) {
        this.messageTypeClassMapping.put(messageType, messageClass);
    }

    @Override
    public ClientMessageChannel createClientChannel(SessionProvider sessions, int maxReconnectTries, int timeout, boolean followRedirects) {
        return this.createClientChannel(sessions, maxReconnectTries, timeout, followRedirects, null, null);
    }

    public ClientMessageChannel createClientChannel(SessionProvider sessions, int maxReconnectTries, int timeout, boolean followRedirects, MessageTransportFactory transportFactory, TCMessageFactory messageFactory) {
        TCMessageFactory msgFactory;
        if (messageFactory == null) {
            msgFactory = new TCMessageFactoryImpl(sessions, this.monitor);
            for (Map.Entry<TCMessageType, Class<? extends TCMessage>> entry : this.messageTypeClassMapping.entrySet()) {
                msgFactory.addClassMapping(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<TCMessageType, Object> entry : this.messageTypeFactoryMapping.entrySet()) {
                msgFactory.addClassMapping(entry.getKey(), (GeneratedMessageFactory)entry.getValue());
            }
        } else {
            msgFactory = messageFactory;
        }
        ClientMessageChannelImpl rv = new ClientMessageChannelImpl(msgFactory, this.messageRouter, sessions, this.productId);
        if (transportFactory == null) {
            transportFactory = new MessageTransportFactoryImpl(this.transportMessageFactory, this.connectionHealthChecker, this.connectionManager, maxReconnectTries, timeout, this.callbackPort, followRedirects, this.handshakeErrHandler, this.reconnectionRejectedHandler, this.securityManager);
        }
        NetworkStackHarness networkStackHarness = this.stackHarnessFactory.createClientHarness(transportFactory, rv, new MessageTransportListener[0]);
        networkStackHarness.finalizeStack();
        return rv;
    }

    @Override
    public NetworkListener createListener(TCSocketAddress addr, boolean transportDisconnectRemovesChannel, NodeNameProvider activeNameProvider) {
        return this.createListener(addr, transportDisconnectRemovesChannel, new NullConnectionIDFactoryImpl(), true, null, activeNameProvider);
    }

    @Override
    public NetworkListener createListener(TCSocketAddress addr, boolean transportDisconnectRemovesChannel, ConnectionIDFactory connectionIdFactory) {
        return this.createListener(addr, transportDisconnectRemovesChannel, connectionIdFactory, true, null, null);
    }

    NetworkListener createListener(TCSocketAddress addr, boolean transportDisconnectRemovesChannel, ConnectionIDFactory connectionIdFactory, boolean reuseAddr, WireProtocolMessageSink wireProtoMsgSnk, NodeNameProvider activeProvider) {
        if (this.shutdown.isSet()) {
            throw new IllegalStateException("Comms manger shut down");
        }
        final TCMessageFactoryImpl msgFactory = new TCMessageFactoryImpl(this.sessionManager, this.monitor);
        for (Map.Entry<TCMessageType, Class<? extends TCMessage>> entry : this.messageTypeClassMapping.entrySet()) {
            msgFactory.addClassMapping(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<TCMessageType, Object> entry : this.messageTypeFactoryMapping.entrySet()) {
            msgFactory.addClassMapping(entry.getKey(), (GeneratedMessageFactory)entry.getValue());
        }
        ServerMessageChannelFactory channelFactory = new ServerMessageChannelFactory(){

            @Override
            public MessageChannelInternal createNewChannel(ChannelID id, ProductID prodId) {
                return new ServerMessageChannelImpl(id, CommunicationsManagerImpl.this.messageRouter, msgFactory, CommunicationsManagerImpl.this.serverID, prodId);
            }
        };
        if (!this.healthCheckerConfig.isCallbackPortListenerNeeded()) {
            this.callbackPort = addr.getPort();
        }
        ChannelManagerImpl channelManagerImpl = new ChannelManagerImpl(transportDisconnectRemovesChannel, channelFactory);
        return new NetworkListenerImpl(addr, this, channelManagerImpl, msgFactory, reuseAddr, connectionIdFactory, wireProtoMsgSnk, activeProvider);
    }

    TCListener createCommsListener(TCSocketAddress addr, ServerMessageChannelFactory channelFactory, boolean resueAddr, Set<ConnectionID> initialConnectionIDs, NodeNameProvider activeProvider, ConnectionIDFactory connectionIdFactory, WireProtocolMessageSink wireProtocolMessageSink) throws IOException {
        MessageTransportFactory transportFactory = new MessageTransportFactory(){

            @Override
            public ClientConnectionEstablisher createClientConnectionEstablisher() {
                throw new AssertionError();
            }

            @Override
            public MessageTransport createNewTransport() {
                throw new AssertionError();
            }

            @Override
            public MessageTransport createNewTransport(ConnectionID connectionID, TransportHandshakeErrorHandler handler, TransportHandshakeMessageFactory handshakeMessageFactory, List<MessageTransportListener> transportListeners) {
                ServerMessageTransport rv = new ServerMessageTransport(connectionID, handler, handshakeMessageFactory);
                rv.addTransportListeners(transportListeners);
                rv.addTransportListener(CommunicationsManagerImpl.this.connectionHealthChecker);
                return rv;
            }

            @Override
            public MessageTransport createNewTransport(ConnectionID connectionId, TCConnection connection, TransportHandshakeErrorHandler handler, TransportHandshakeMessageFactory handshakeMessageFactory, List<MessageTransportListener> transportListeners) {
                ServerMessageTransport rv = new ServerMessageTransport(connectionId, connection, handler, handshakeMessageFactory);
                rv.addTransportListeners(transportListeners);
                rv.addTransportListener(CommunicationsManagerImpl.this.connectionHealthChecker);
                return rv;
            }
        };
        ServerStackProvider stackProvider = new ServerStackProvider(initialConnectionIDs, activeProvider, this.stackHarnessFactory, channelFactory, transportFactory, this.transportMessageFactory, connectionIdFactory, this.connectionPolicy, new WireProtocolAdaptorFactoryImpl(), wireProtocolMessageSink, this.licenseLock, this.commsMgrName, this.securityManager);
        return this.connectionManager.createListener(addr, stackProvider, 512, resueAddr);
    }

    private void startHealthCheckCallbackPortListener(HealthCheckerConfig healthCheckrConfig) {
        InetAddress bindAddr;
        if (!healthCheckrConfig.isCallbackPortListenerNeeded()) {
            logger.info("HealthCheck CallbackPort Listener not requested");
            return;
        }
        String bindAddress = healthCheckrConfig.getCallbackPortListenerBindAddress();
        if (bindAddress == null || bindAddress.equals("")) {
            bindAddress = "0.0.0.0";
        }
        try {
            bindAddr = InetAddress.getByName(bindAddress);
        }
        catch (UnknownHostException e) {
            throw new TCRuntimeException("Cannot create InetAddress instance for 0.0.0.0");
        }
        AddressChecker addressChecker = new AddressChecker();
        if (!addressChecker.isLegalBindAddress(bindAddr)) {
            throw new TCRuntimeException("Invalid bind address [" + bindAddr + "]. Local addresses are " + addressChecker.getAllLocalAddresses());
        }
        this.startCallbackListener(healthCheckrConfig, bindAddr);
    }

    private void startCallbackListener(HealthCheckerConfig healthCheckrConfig, InetAddress bindAddr) {
        for (Integer bindPort : healthCheckrConfig.getCallbackPortListenerBindPort()) {
            if (bindPort == -1) {
                logger.info("HealthCheck CallbackPort Listener disabled");
                return;
            }
            TCSocketAddress address = new TCSocketAddress(bindAddr, (int)bindPort);
            NetworkListener callbackPortListener = this.createListener(address, true, new DefaultConnectionIdFactory());
            try {
                callbackPortListener.start(Collections.<ConnectionID>emptySet());
                this.callbackPort = callbackPortListener.getBindPort();
                this.callbackportListener = callbackPortListener;
                logger.info("HealthCheck CallbackPort Listener started at " + callbackPortListener.getBindAddress() + ":" + this.callbackPort);
                return;
            }
            catch (IOException ioe) {
                if (healthCheckrConfig.getCallbackPortListenerBindPort().size() != 1) continue;
                logger.warn("Unable to start HealthCheck CallbackPort Listener at" + address + ": " + ioe);
            }
        }
        logger.warn("Unable to start HealthCheck CallbackPort Listener on any port");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerListener(NetworkListener lsnr) {
        Set<NetworkListener> set = this.listeners;
        synchronized (set) {
            boolean added = this.listeners.add(lsnr);
            if (!added) {
                logger.warn("replaced an existing listener in the listener map");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterListener(NetworkListener lsnr) {
        Set<NetworkListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(lsnr);
        }
    }

    public ConnectionHealthChecker getConnHealthChecker() {
        return this.connectionHealthChecker;
    }

    public void setConnHealthChecker(ConnectionHealthChecker checker) {
        this.connectionHealthChecker.stop();
        this.connectionHealthChecker = checker;
        this.connectionHealthChecker.start();
    }

    public NetworkListener getCallbackPortListener() {
        return this.callbackportListener;
    }

    public TCMessageRouter getMessageRouter() {
        return this.messageRouter;
    }
}

