/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.core;

import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.net.core.CoreNIOServices;
import com.tc.net.core.SocketParams;
import com.tc.net.core.TCComm;
import com.tc.net.core.TCWorkerCommManager;

class TCCommImpl
implements TCComm {
    private final TCWorkerCommManager workerCommMgr;
    private final CoreNIOServices commThread;
    private final String commThreadName = "TCComm Main Selector Thread";
    private static final TCLogger logger = TCLogging.getLogger(TCCommImpl.class);
    private volatile boolean started = false;

    TCCommImpl(String name, int workerCommCount, SocketParams socketParams) {
        if (workerCommCount > 0) {
            this.workerCommMgr = new TCWorkerCommManager(name, workerCommCount, socketParams);
        } else {
            logger.info("Comm Worker Threads NOT requested");
            this.workerCommMgr = null;
        }
        this.commThread = new CoreNIOServices(name + ":" + "TCComm Main Selector Thread", this.workerCommMgr, socketParams);
    }

    protected int getWeightForWorkerComm(int workerCommId) {
        if (this.workerCommMgr != null) {
            return this.workerCommMgr.getWeightForWorkerComm(workerCommId);
        }
        return 0;
    }

    protected CoreNIOServices getWorkerComm(int workerCommId) {
        if (this.workerCommMgr != null) {
            return this.workerCommMgr.getWorkerComm(workerCommId);
        }
        return null;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public boolean isStopped() {
        return !this.started;
    }

    @Override
    public final synchronized void start() {
        if (!this.started) {
            this.started = true;
            if (logger.isDebugEnabled()) {
                logger.debug("Start requested");
            }
            if (this.workerCommMgr != null) {
                this.workerCommMgr.start();
            }
            this.commThread.start();
        }
    }

    @Override
    public final synchronized void stop() {
        if (this.started) {
            this.started = false;
            if (logger.isDebugEnabled()) {
                logger.debug("Stop requested");
            }
            this.commThread.requestStop();
            if (this.workerCommMgr != null) {
                this.workerCommMgr.stop();
            }
        }
    }

    public CoreNIOServices nioServiceThreadForNewConnection() {
        return this.commThread;
    }

    public CoreNIOServices nioServiceThreadForNewListener() {
        return this.commThread;
    }
}

