/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util;

import com.tc.object.ObjectID;
import com.tc.util.ObjectIDSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class BasicObjectIDSet
extends ObjectIDSet {
    private final List<ObjectIDSet.Range> ranges = new ArrayList<ObjectIDSet.Range>();
    private int size = 0;

    public BasicObjectIDSet() {
    }

    public BasicObjectIDSet(String magic, long ... ids) {
        if (!"ImDoingTesting".equals(magic)) {
            throw new UnsupportedOperationException("This constructor is for testing only");
        }
        Arrays.sort(ids);
        for (long id : ids) {
            this.insertRange(new ObjectIDSet.BasicRange(id, new long[]{1L}));
        }
    }

    @Override
    public Iterator<ObjectID> iterator() {
        return new OIDIterator();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    protected void insertRange(ObjectIDSet.Range range) {
        for (ObjectIDSet.Range smallRange : this.fragment(range)) {
            this.doRangeInsert(smallRange);
        }
    }

    private void doRangeInsert(ObjectIDSet.Range range) {
        if (range.getBitmap().length != 1) {
            throw new IllegalArgumentException("Wrong range size for range " + range);
        }
        if (this.ranges.isEmpty() || RANGE_COMPARATOR.compare(this.ranges.get(this.ranges.size() - 1), range) < 0) {
            this.ranges.add(range);
            this.size += Long.bitCount(range.getBitmap()[0]);
            return;
        }
        throw new UnsupportedOperationException("Inserts out of order");
    }

    @Override
    protected Collection<? extends ObjectIDSet.Range> ranges() {
        return Collections.unmodifiableList(this.ranges);
    }

    private List<ObjectIDSet.Range> fragment(ObjectIDSet.Range r) {
        ArrayList<ObjectIDSet.Range> rangeList = new ArrayList<ObjectIDSet.Range>();
        long start = r.getStart();
        for (long l : r.getBitmap()) {
            rangeList.add(new ObjectIDSet.BasicRange(start, new long[]{l}));
            start += 64L;
        }
        return rangeList;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("BasicObjectIDSet{");
        sb.append("ranges=").append(this.ranges);
        sb.append(", size=").append(this.size);
        sb.append('}');
        return sb.toString();
    }

    private class OIDIterator
    implements Iterator<ObjectID> {
        private final Iterator<? extends ObjectIDSet.Range> rangeIterator;
        private ObjectIDSet.Range current;
        private long mask;

        private OIDIterator() {
            this.rangeIterator = BasicObjectIDSet.this.ranges.iterator();
            this.advance();
        }

        private void advance() {
            do {
                if (this.current == null) {
                    if (this.rangeIterator.hasNext()) {
                        this.current = this.rangeIterator.next();
                        this.mask = 1L;
                        continue;
                    }
                    this.mask = -1L;
                    return;
                }
                this.mask <<= 1;
                if (this.mask != 0L) continue;
                this.current = null;
            } while (this.current == null || (this.current.getBitmap()[0] & this.mask) == 0L);
        }

        @Override
        public boolean hasNext() {
            return this.current != null && this.mask != 0L;
        }

        @Override
        public ObjectID next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ObjectID oid = new ObjectID(this.current.getStart() + (long)Long.numberOfTrailingZeros(this.mask));
            this.advance();
            return oid;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

