/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.msg;

import com.tc.async.api.OrderedEventContext;
import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.net.ClientID;
import com.tc.object.ClientInstanceID;
import com.tc.object.EntityDescriptor;
import com.tc.object.EntityID;
import com.tc.object.tx.TransactionID;
import com.tc.util.Assert;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;

public class SyncReplicationActivity
implements OrderedEventContext {
    private final ActivityID id;
    final ActivityType action;
    private final EntityCreationTuple[] entitiesForSyncStart;
    final EntityDescriptor descriptor;
    final ClientID src;
    final TransactionID tid;
    final TransactionID oldest;
    final byte[] payload;
    final int concurrency;
    final int referenceCount;
    final String debugId;

    public static SyncReplicationActivity createFlushLocalPipelineMessage(EntityID eid, long version) {
        int referenceCount = 0;
        return new SyncReplicationActivity(ActivityID.getNextID(), null, new EntityDescriptor(eid, ClientInstanceID.NULL_ID, version), ClientID.NULL_ID, TransactionID.NULL_ID, TransactionID.NULL_ID, ActivityType.FLUSH_LOCAL_PIPELINE, null, 0, referenceCount, "");
    }

    public static SyncReplicationActivity createOrderingPlaceholder(EntityDescriptor descriptor, ClientID src, TransactionID tid, TransactionID oldest, String debugId) {
        int referenceCount = 0;
        return new SyncReplicationActivity(ActivityID.getNextID(), null, descriptor, src, tid, oldest, ActivityType.ORDERING_PLACEHOLDER, null, 0, referenceCount, debugId);
    }

    public static SyncReplicationActivity createReplicatedMessage(EntityDescriptor descriptor, ClientID src, TransactionID tid, TransactionID oldest, ActivityType action, byte[] payload, int concurrency, String debugId) {
        Assert.assertTrue(ActivityType.FLUSH_LOCAL_PIPELINE != action);
        Assert.assertTrue(ActivityType.ORDERING_PLACEHOLDER != action);
        Assert.assertTrue(ActivityType.SYNC_BEGIN != action);
        Assert.assertTrue(ActivityType.SYNC_END != action);
        Assert.assertTrue(ActivityType.SYNC_ENTITY_BEGIN != action);
        Assert.assertTrue(ActivityType.SYNC_ENTITY_END != action);
        Assert.assertTrue(ActivityType.SYNC_ENTITY_CONCURRENCY_BEGIN != action);
        Assert.assertTrue(ActivityType.SYNC_ENTITY_CONCURRENCY_END != action);
        Assert.assertTrue(ActivityType.SYNC_ENTITY_CONCURRENCY_PAYLOAD != action);
        Assert.assertTrue(ActivityType.SYNC_START != action);
        int referenceCount = 0;
        return new SyncReplicationActivity(ActivityID.getNextID(), null, descriptor, src, tid, oldest, action, payload, concurrency, referenceCount, debugId);
    }

    public static SyncReplicationActivity createStartSyncMessage(EntityCreationTuple[] tuplesForCreation) {
        int referenceCount = 0;
        return new SyncReplicationActivity(ActivityID.getNextID(), tuplesForCreation, EntityDescriptor.NULL_ID, ClientID.NULL_ID, TransactionID.NULL_ID, TransactionID.NULL_ID, ActivityType.SYNC_BEGIN, null, 0, referenceCount, "");
    }

    public static SyncReplicationActivity createEndSyncMessage(byte[] extras) {
        int referenceCount = 0;
        return new SyncReplicationActivity(ActivityID.getNextID(), null, EntityDescriptor.NULL_ID, ClientID.NULL_ID, TransactionID.NULL_ID, TransactionID.NULL_ID, ActivityType.SYNC_END, extras, 0, referenceCount, "");
    }

    public static SyncReplicationActivity createStartEntityMessage(EntityID id, long version, byte[] configPayload, int references) {
        return new SyncReplicationActivity(ActivityID.getNextID(), null, SyncReplicationActivity.descriptorWithoutClient(id, version), ClientID.NULL_ID, TransactionID.NULL_ID, TransactionID.NULL_ID, ActivityType.SYNC_ENTITY_BEGIN, configPayload, 0, references, "");
    }

    public static SyncReplicationActivity createEndEntityMessage(EntityID id, long version) {
        int referenceCount = 0;
        return new SyncReplicationActivity(ActivityID.getNextID(), null, SyncReplicationActivity.descriptorWithoutClient(id, version), ClientID.NULL_ID, TransactionID.NULL_ID, TransactionID.NULL_ID, ActivityType.SYNC_ENTITY_END, null, 0, referenceCount, "");
    }

    public static SyncReplicationActivity createStartEntityKeyMessage(EntityID id, long version, int concurrency) {
        Assert.assertTrue(concurrency > 0);
        int referenceCount = 0;
        return new SyncReplicationActivity(ActivityID.getNextID(), null, SyncReplicationActivity.descriptorWithoutClient(id, version), ClientID.NULL_ID, TransactionID.NULL_ID, TransactionID.NULL_ID, ActivityType.SYNC_ENTITY_CONCURRENCY_BEGIN, null, concurrency, referenceCount, "");
    }

    public static SyncReplicationActivity createEndEntityKeyMessage(EntityID id, long version, int concurrency) {
        Assert.assertTrue(concurrency > 0);
        int referenceCount = 0;
        return new SyncReplicationActivity(ActivityID.getNextID(), null, SyncReplicationActivity.descriptorWithoutClient(id, version), ClientID.NULL_ID, TransactionID.NULL_ID, TransactionID.NULL_ID, ActivityType.SYNC_ENTITY_CONCURRENCY_END, null, concurrency, referenceCount, "");
    }

    public static SyncReplicationActivity createPayloadMessage(EntityID id, long version, int concurrency, byte[] payload, String debugId) {
        Assert.assertTrue(concurrency > 0);
        int referenceCount = 0;
        return new SyncReplicationActivity(ActivityID.getNextID(), null, SyncReplicationActivity.descriptorWithoutClient(id, version), ClientID.NULL_ID, TransactionID.NULL_ID, TransactionID.NULL_ID, ActivityType.SYNC_ENTITY_CONCURRENCY_PAYLOAD, payload, concurrency, referenceCount, debugId);
    }

    public static SyncReplicationActivity createStartMessage() {
        int referenceCount = 0;
        return new SyncReplicationActivity(ActivityID.getNextID(), null, EntityDescriptor.NULL_ID, ClientID.NULL_ID, TransactionID.NULL_ID, TransactionID.NULL_ID, ActivityType.SYNC_START, null, 0, referenceCount, "");
    }

    private static EntityDescriptor descriptorWithoutClient(EntityID id, long version) {
        return new EntityDescriptor(id, ClientInstanceID.NULL_ID, version);
    }

    private SyncReplicationActivity(ActivityID id, EntityCreationTuple[] entitiesForSyncStart, EntityDescriptor descriptor, ClientID src, TransactionID tid, TransactionID oldest, ActivityType action, byte[] payload, int concurrency, int referenceCount, String debugId) {
        Assert.assertNotNull(id);
        Assert.assertNotNull((Object)action);
        if (ActivityType.SYNC_BEGIN == action) {
            Assert.assertNotNull(entitiesForSyncStart);
        } else {
            Assert.assertNull(entitiesForSyncStart);
        }
        Assert.assertNotNull(descriptor);
        Assert.assertNotNull(src);
        Assert.assertNotNull(tid);
        Assert.assertNotNull(oldest);
        this.id = id;
        this.action = action;
        this.entitiesForSyncStart = entitiesForSyncStart;
        this.descriptor = descriptor;
        this.src = src;
        this.tid = tid;
        this.oldest = oldest;
        this.payload = payload;
        this.concurrency = concurrency;
        this.referenceCount = referenceCount;
        this.debugId = debugId;
    }

    @Override
    public long getSequenceID() {
        return this.id.id;
    }

    public ActivityID getActivityID() {
        return this.id;
    }

    public EntityCreationTuple[] getEntitiesToCreateForSync() {
        Assert.assertTrue(ActivityType.SYNC_BEGIN == this.action);
        return this.entitiesForSyncStart;
    }

    public byte[] getExtendedData() {
        Assert.assertTrue(ActivityType.SYNC_BEGIN != this.action);
        return this.payload;
    }

    public ClientID getSource() {
        Assert.assertTrue(ActivityType.SYNC_BEGIN != this.action);
        return this.src;
    }

    public TransactionID getTransactionID() {
        Assert.assertTrue(ActivityType.SYNC_BEGIN != this.action);
        return this.tid;
    }

    public TransactionID getOldestTransactionOnClient() {
        Assert.assertTrue(ActivityType.SYNC_BEGIN != this.action);
        return this.oldest;
    }

    public EntityDescriptor getEntityDescriptor() {
        return this.descriptor;
    }

    public EntityID getEntityID() {
        Assert.assertNotNull(this.descriptor);
        return this.descriptor.getEntityID();
    }

    public int getConcurrency() {
        Assert.assertFalse(ActivityType.SYNC_ENTITY_BEGIN == this.action);
        Assert.assertTrue(ActivityType.SYNC_BEGIN != this.action);
        return this.concurrency;
    }

    public int getReferenceCount() {
        Assert.assertTrue(ActivityType.SYNC_ENTITY_BEGIN == this.action);
        Assert.assertTrue(ActivityType.SYNC_BEGIN != this.action);
        return this.referenceCount;
    }

    public ActivityType getActivityType() {
        return this.action;
    }

    public String getDebugID() {
        return this.debugId;
    }

    public boolean isSyncActivity() {
        return this.action.ordinal() >= ActivityType.SYNC_START.ordinal();
    }

    protected void serializeTo(TCByteBufferOutput out) {
        Assert.assertTrue(ActivityType.INVALID != this.action);
        Assert.assertTrue(ActivityType.FLUSH_LOCAL_PIPELINE != this.action);
        out.writeLong(this.id.id);
        out.writeInt(this.action.ordinal());
        if (ActivityType.SYNC_BEGIN == this.action) {
            out.writeInt(this.entitiesForSyncStart.length);
            for (int i = 0; i < this.entitiesForSyncStart.length; ++i) {
                this.entitiesForSyncStart[i].serializeTo(out);
            }
        } else {
            this.descriptor.serializeTo(out);
            byte sourceNodeType = this.src.getNodeType();
            Assert.assertTrue(1 == sourceNodeType);
            out.write(sourceNodeType);
            this.src.serializeTo(out);
            out.writeLong(this.tid.toLong());
            out.writeLong(this.oldest.toLong());
            if (this.payload != null) {
                out.writeInt(this.payload.length);
                out.write(this.payload);
            } else {
                out.writeInt(0);
            }
            if (ActivityType.SYNC_ENTITY_BEGIN == this.action) {
                out.writeInt(this.referenceCount);
            } else {
                out.writeInt(this.concurrency);
            }
        }
        String debugIdToWrite = this.debugId != null ? this.debugId : "";
        out.writeString(debugIdToWrite);
    }

    public static SyncReplicationActivity deserializeFrom(TCByteBufferInput in) throws IOException {
        ActivityID activityID = new ActivityID(in.readLong());
        ActivityType action = ActivityType.values()[in.readInt()];
        EntityCreationTuple[] entitiesForSyncStart = null;
        EntityDescriptor descriptor = EntityDescriptor.NULL_ID;
        ClientID source = ClientID.NULL_ID;
        TransactionID tid = TransactionID.NULL_ID;
        TransactionID oldest = TransactionID.NULL_ID;
        byte[] payload = null;
        int concurrency = 0;
        int referenceCount = 0;
        if (ActivityType.SYNC_BEGIN == action) {
            int arraySize = in.readInt();
            entitiesForSyncStart = new EntityCreationTuple[arraySize];
            for (int i = 0; i < arraySize; ++i) {
                entitiesForSyncStart[i] = EntityCreationTuple.deserializeFrom(in);
            }
        } else {
            descriptor = EntityDescriptor.readFrom(in);
            int sourceNodeType = in.read();
            Assert.assertTrue(1 == sourceNodeType);
            source = new ClientID().deserializeFrom(in);
            tid = new TransactionID(in.readLong());
            oldest = new TransactionID(in.readLong());
            int length = in.readInt();
            payload = new byte[length];
            in.readFully(payload);
            concurrency = 0;
            referenceCount = 0;
            if (ActivityType.SYNC_ENTITY_BEGIN == action) {
                referenceCount = in.readInt();
            } else {
                concurrency = in.readInt();
            }
        }
        String debug = in.readString();
        return new SyncReplicationActivity(activityID, entitiesForSyncStart, descriptor, source, tid, oldest, action, payload, concurrency, referenceCount, debug);
    }

    public String toString() {
        return "SyncReplicationActivity{activityID=" + this.id + ", entityID=" + this.descriptor.getEntityID() + ", src=" + this.src + ", tid=" + this.tid + ", oldest=" + this.oldest + ", action=" + (Object)((Object)this.action) + ", concurrency=" + this.concurrency + ", debug=" + this.debugId + '}';
    }

    public static class EntityCreationTuple {
        public final EntityID id;
        public final long version;
        public final byte[] configPayload;
        public final boolean canDelete;

        public EntityCreationTuple(EntityID id, long version, byte[] configPayload, boolean canDelete) {
            this.id = id;
            this.version = version;
            this.configPayload = configPayload;
            this.canDelete = canDelete;
        }

        public void serializeTo(TCByteBufferOutput out) {
            this.id.serializeTo(out);
            out.writeLong(this.version);
            if (null != this.configPayload) {
                out.writeInt(this.configPayload.length);
                out.write(this.configPayload);
            } else {
                out.writeInt(0);
            }
            out.writeBoolean(this.canDelete);
        }

        public static EntityCreationTuple deserializeFrom(TCByteBufferInput in) throws IOException {
            EntityID id = EntityID.readFrom(in);
            long version = in.readLong();
            int configLength = in.readInt();
            byte[] configPayload = new byte[configLength];
            in.readFully(configPayload);
            boolean canDelete = in.readBoolean();
            return new EntityCreationTuple(id, version, configPayload, canDelete);
        }
    }

    public static class ActivityID {
        private static final AtomicLong NEXT_ID = new AtomicLong(1L);
        public final long id;

        public static ActivityID getNextID() {
            return new ActivityID(NEXT_ID.getAndIncrement());
        }

        public ActivityID(long id) {
            this.id = id;
        }

        public boolean equals(Object obj) {
            boolean isEqual;
            boolean bl = isEqual = this == obj;
            if (!isEqual && obj instanceof ActivityID) {
                isEqual = this.id == ((ActivityID)obj).id;
            }
            return isEqual;
        }

        public int hashCode() {
            return (int)this.id;
        }
    }

    public static enum ActivityType {
        INVALID,
        FLUSH_LOCAL_PIPELINE,
        ORDERING_PLACEHOLDER,
        CREATE_ENTITY,
        RECONFIGURE_ENTITY,
        INVOKE_ACTION,
        DESTROY_ENTITY,
        FETCH_ENTITY,
        RELEASE_ENTITY,
        SYNC_START,
        SYNC_BEGIN,
        SYNC_END,
        SYNC_ENTITY_BEGIN,
        SYNC_ENTITY_END,
        SYNC_ENTITY_CONCURRENCY_BEGIN,
        SYNC_ENTITY_CONCURRENCY_PAYLOAD,
        SYNC_ENTITY_CONCURRENCY_END;

    }
}

