/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.messages;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ReconnectMessage {
    private final UUID clientId;
    private final Set<String> caches;
    private final ConcurrentMap<String, Set<Long>> hashInvalidationsInProgressPerCache = new ConcurrentHashMap<String, Set<Long>>();
    private final Set<String> cachesWithClearInProgress = Collections.newSetFromMap(new ConcurrentHashMap());

    public ReconnectMessage(UUID clientId) {
        this(clientId, Collections.emptySet());
    }

    public ReconnectMessage(UUID clientId, Set<String> caches) {
        if (clientId == null) {
            throw new IllegalStateException("ClientID cannot be null");
        }
        this.clientId = clientId;
        this.caches = new HashSet<String>(caches);
    }

    public UUID getClientId() {
        return this.clientId;
    }

    public Set<String> getAllCaches() {
        return this.caches;
    }

    public void addInvalidationsInProgress(String cacheId, Set<Long> hashInvalidationsInProgress) {
        this.hashInvalidationsInProgressPerCache.put(cacheId, hashInvalidationsInProgress);
    }

    public Set<Long> getInvalidationsInProgress(String cacheId) {
        Set hashToInvalidate = (Set)this.hashInvalidationsInProgressPerCache.get(cacheId);
        return hashToInvalidate == null ? Collections.emptySet() : hashToInvalidate;
    }

    public void addClearInProgress(String cacheId) {
        this.cachesWithClearInProgress.add(cacheId);
    }

    public boolean isClearInProgress(String cacheId) {
        return this.cachesWithClearInProgress.contains(cacheId);
    }
}

