/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol;

import com.tc.net.core.TCConnection;
import com.tc.net.protocol.IllegalReconnectException;
import com.tc.net.protocol.NetworkStackHarness;
import com.tc.net.protocol.tcm.ChannelID;
import com.tc.net.protocol.tcm.MessageChannelInternal;
import com.tc.net.protocol.tcm.ServerMessageChannelFactory;
import com.tc.net.protocol.transport.MessageTransport;
import com.tc.net.protocol.transport.MessageTransportFactory;
import com.tc.util.Assert;
import com.tc.util.concurrent.SetOnceFlag;

public abstract class AbstractNetworkStackHarness
implements NetworkStackHarness {
    protected MessageTransport transport;
    protected MessageChannelInternal channel;
    private final ServerMessageChannelFactory channelFactory;
    private final MessageTransportFactory transportFactory;
    private final boolean isClientStack;
    private final SetOnceFlag finalized = new SetOnceFlag();

    protected AbstractNetworkStackHarness(ServerMessageChannelFactory channelFactory, MessageTransport transport) {
        this.channelFactory = channelFactory;
        this.transportFactory = null;
        this.transport = transport;
        this.isClientStack = false;
    }

    protected AbstractNetworkStackHarness(MessageTransportFactory transportFactory, MessageChannelInternal channel) {
        this.transportFactory = transportFactory;
        this.channelFactory = null;
        this.channel = channel;
        this.isClientStack = true;
    }

    @Override
    public final MessageTransport attachNewConnection(TCConnection connection) throws IllegalReconnectException {
        Assert.eval("Attempt to connect a transport to a stack that hasn't been finalized.", this.finalized.isSet());
        this.transport.attachNewConnection(connection);
        return this.transport;
    }

    @Override
    public final void finalizeStack() {
        if (this.finalized.attemptSet()) {
            if (this.isClientStack) {
                Assert.assertNotNull(this.channel);
                Assert.assertNotNull(this.transportFactory);
                this.transport = this.transportFactory.createNewTransport();
            } else {
                Assert.assertNotNull(this.transport);
                Assert.assertNotNull(this.channelFactory);
                this.channel = this.channelFactory.createNewChannel(new ChannelID(this.transport.getConnectionId().getChannelID()), this.transport.getConnectionId().getProductId());
            }
        } else {
            throw Assert.failure("Attempt to finalize an already finalized stack");
        }
        this.createIntermediateLayers();
        this.connectStack();
    }

    protected abstract void createIntermediateLayers();

    protected abstract void connectStack();

    public String toString() {
        return "AbstractNetworkStackHarness[ transport:" + this.transport + "channel" + this.channel + ",isclientStack:" + this.isClientStack + "]";
    }
}

