/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.messages;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.ehcache.clustered.common.internal.ServerStoreConfiguration;
import org.ehcache.clustered.common.internal.messages.ChainCodec;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityMessage;
import org.ehcache.clustered.common.internal.messages.EhcacheMessageType;
import org.ehcache.clustered.common.internal.messages.MessageCodecUtils;
import org.ehcache.clustered.common.internal.messages.PassiveReplicationMessage;
import org.ehcache.clustered.common.internal.store.Chain;
import org.terracotta.runnel.Struct;
import org.terracotta.runnel.StructBuilder;
import org.terracotta.runnel.decoding.StructDecoder;
import org.terracotta.runnel.encoding.StructEncoder;

class PassiveReplicationMessageCodec {
    private static final String CHAIN_FIELD = "chain";
    private static final Struct CLIENT_ID_TRACK_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, EhcacheMessageType.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).int64("msgId", 15).int64("msbUUID", 20).int64("lsbUUID", 21).build();
    private static final Struct CHAIN_REPLICATION_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, EhcacheMessageType.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).int64("msgId", 15).int64("msbUUID", 20).int64("lsbUUID", 21).string("serverStoreName", 30).int64("key", 40).struct("chain", 45, ChainCodec.CHAIN_STRUCT).build();
    private static final Struct CLEAR_INVALIDATION_COMPLETE_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, EhcacheMessageType.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).string("serverStoreName", 20).build();
    private static final Struct INVALIDATION_COMPLETE_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, EhcacheMessageType.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).string("serverStoreName", 20).int64("key", 30).build();
    private static final Struct CREATE_SERVER_STORE_REPLICATION_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, EhcacheMessageType.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).int64("msgId", 15).int64("msbUUID", 20).int64("lsbUUID", 21).string("serverStoreName", 30).string("keyType", 40).string("keySerializerType", 41).string("valueType", 45).string("valueSerializerType", 46).enm("consistency", 50, MessageCodecUtils.CONSISTENCY_ENUM_MAPPING).int64("poolSize", 60).string("resourceName", 65).build();
    private static final Struct DESTROY_SERVER_STORE_REPLICATION_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, EhcacheMessageType.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).int64("msgId", 15).int64("msbUUID", 20).int64("lsbUUID", 21).string("serverStoreName", 30).build();
    private final ChainCodec chainCodec = new ChainCodec();
    private final MessageCodecUtils messageCodecUtils = new MessageCodecUtils();

    PassiveReplicationMessageCodec() {
    }

    public byte[] encode(PassiveReplicationMessage message) {
        switch (message.getMessageType()) {
            case CLIENT_ID_TRACK_OP: {
                return this.encodeClientIdTrackMessage((PassiveReplicationMessage.ClientIDTrackerMessage)message);
            }
            case CHAIN_REPLICATION_OP: {
                return this.encodeChainReplicationMessage((PassiveReplicationMessage.ChainReplicationMessage)message);
            }
            case CLEAR_INVALIDATION_COMPLETE: {
                return this.encodeClearInvalidationCompleteMessage((PassiveReplicationMessage.ClearInvalidationCompleteMessage)message);
            }
            case INVALIDATION_COMPLETE: {
                return this.encodeInvalidationCompleteMessage((PassiveReplicationMessage.InvalidationCompleteMessage)message);
            }
            case CREATE_SERVER_STORE_REPLICATION: {
                return this.encodeCreateServerStoreReplicationMessage((PassiveReplicationMessage.CreateServerStoreReplicationMessage)message);
            }
            case DESTROY_SERVER_STORE_REPLICATION: {
                return this.encoreDestroyServerStoreReplicationMessage((PassiveReplicationMessage.DestroyServerStoreReplicationMessage)message);
            }
        }
        throw new UnsupportedOperationException("This operation is not supported : " + (Object)((Object)message.getMessageType()));
    }

    private byte[] encoreDestroyServerStoreReplicationMessage(PassiveReplicationMessage.DestroyServerStoreReplicationMessage message) {
        StructEncoder encoder = DESTROY_SERVER_STORE_REPLICATION_STRUCT.encoder();
        this.messageCodecUtils.encodeMandatoryFields(encoder, message);
        encoder.string("serverStoreName", message.getStoreName());
        return encoder.encode().array();
    }

    private byte[] encodeCreateServerStoreReplicationMessage(PassiveReplicationMessage.CreateServerStoreReplicationMessage message) {
        StructEncoder encoder = CREATE_SERVER_STORE_REPLICATION_STRUCT.encoder();
        this.messageCodecUtils.encodeMandatoryFields(encoder, message);
        encoder.string("serverStoreName", message.getStoreName());
        this.messageCodecUtils.encodeServerStoreConfiguration(encoder, message.getStoreConfiguration());
        return encoder.encode().array();
    }

    private byte[] encodeInvalidationCompleteMessage(PassiveReplicationMessage.InvalidationCompleteMessage message) {
        StructEncoder encoder = INVALIDATION_COMPLETE_STRUCT.encoder();
        ((StructEncoder)encoder.enm("opCode", (Object)message.getMessageType())).string("serverStoreName", message.getCacheId()).int64("key", message.getKey());
        return encoder.encode().array();
    }

    private byte[] encodeClearInvalidationCompleteMessage(PassiveReplicationMessage.ClearInvalidationCompleteMessage message) {
        StructEncoder encoder = CLEAR_INVALIDATION_COMPLETE_STRUCT.encoder();
        ((StructEncoder)encoder.enm("opCode", (Object)message.getMessageType())).string("serverStoreName", message.getCacheId());
        return encoder.encode().array();
    }

    private byte[] encodeChainReplicationMessage(PassiveReplicationMessage.ChainReplicationMessage message) {
        StructEncoder encoder = CHAIN_REPLICATION_STRUCT.encoder();
        this.messageCodecUtils.encodeMandatoryFields(encoder, message);
        encoder.string("serverStoreName", message.getCacheId());
        encoder.int64("key", message.getKey());
        this.chainCodec.encode(encoder.struct(CHAIN_FIELD), message.getChain());
        return encoder.encode().array();
    }

    private byte[] encodeClientIdTrackMessage(PassiveReplicationMessage.ClientIDTrackerMessage message) {
        StructEncoder encoder = CLIENT_ID_TRACK_STRUCT.encoder();
        this.messageCodecUtils.encodeMandatoryFields(encoder, message);
        return encoder.encode().array();
    }

    public EhcacheEntityMessage decode(EhcacheMessageType messageType, ByteBuffer messageBuffer) {
        switch (messageType) {
            case CLIENT_ID_TRACK_OP: {
                return this.decodeClientIdTrackMessage(messageBuffer);
            }
            case CHAIN_REPLICATION_OP: {
                return this.decodeChainReplicationMessage(messageBuffer);
            }
            case CLEAR_INVALIDATION_COMPLETE: {
                return this.decodeClearInvalidationCompleteMessage(messageBuffer);
            }
            case INVALIDATION_COMPLETE: {
                return this.decodeInvalidationCompleteMessage(messageBuffer);
            }
            case CREATE_SERVER_STORE_REPLICATION: {
                return this.decodeCreateServerStoreReplicationMessage(messageBuffer);
            }
            case DESTROY_SERVER_STORE_REPLICATION: {
                return this.decodeDestroyServerStoreReplicationMessage(messageBuffer);
            }
        }
        throw new UnsupportedOperationException("Unknown message type: " + (Object)((Object)messageType));
    }

    private PassiveReplicationMessage.DestroyServerStoreReplicationMessage decodeDestroyServerStoreReplicationMessage(ByteBuffer messageBuffer) {
        StructDecoder decoder = DESTROY_SERVER_STORE_REPLICATION_STRUCT.decoder(messageBuffer);
        Long msgId = decoder.int64("msgId");
        UUID clientId = this.messageCodecUtils.decodeUUID(decoder);
        String storeName = decoder.string("serverStoreName");
        return new PassiveReplicationMessage.DestroyServerStoreReplicationMessage(msgId, clientId, storeName);
    }

    private PassiveReplicationMessage.CreateServerStoreReplicationMessage decodeCreateServerStoreReplicationMessage(ByteBuffer messageBuffer) {
        StructDecoder decoder = CREATE_SERVER_STORE_REPLICATION_STRUCT.decoder(messageBuffer);
        Long msgId = decoder.int64("msgId");
        UUID clientId = this.messageCodecUtils.decodeUUID(decoder);
        String storeName = decoder.string("serverStoreName");
        ServerStoreConfiguration configuration = this.messageCodecUtils.decodeServerStoreConfiguration(decoder);
        return new PassiveReplicationMessage.CreateServerStoreReplicationMessage(msgId, clientId, storeName, configuration);
    }

    private PassiveReplicationMessage.InvalidationCompleteMessage decodeInvalidationCompleteMessage(ByteBuffer messageBuffer) {
        StructDecoder decoder = INVALIDATION_COMPLETE_STRUCT.decoder(messageBuffer);
        String storeId = decoder.string("serverStoreName");
        Long key = decoder.int64("key");
        return new PassiveReplicationMessage.InvalidationCompleteMessage(storeId, key);
    }

    private PassiveReplicationMessage.ClearInvalidationCompleteMessage decodeClearInvalidationCompleteMessage(ByteBuffer messageBuffer) {
        StructDecoder decoder = CLEAR_INVALIDATION_COMPLETE_STRUCT.decoder(messageBuffer);
        return new PassiveReplicationMessage.ClearInvalidationCompleteMessage(decoder.string("serverStoreName"));
    }

    private PassiveReplicationMessage.ChainReplicationMessage decodeChainReplicationMessage(ByteBuffer messageBuffer) {
        StructDecoder decoder = CHAIN_REPLICATION_STRUCT.decoder(messageBuffer);
        Long msgId = decoder.int64("msgId");
        UUID clientId = this.messageCodecUtils.decodeUUID(decoder);
        String cacheId = decoder.string("serverStoreName");
        Long key = decoder.int64("key");
        Chain chain = this.chainCodec.decode(decoder.struct(CHAIN_FIELD));
        return new PassiveReplicationMessage.ChainReplicationMessage(cacheId, key, chain, msgId, clientId);
    }

    private PassiveReplicationMessage.ClientIDTrackerMessage decodeClientIdTrackMessage(ByteBuffer messageBuffer) {
        StructDecoder decoder = CLIENT_ID_TRACK_STRUCT.decoder(messageBuffer);
        Long msgId = decoder.int64("msgId");
        UUID clientId = this.messageCodecUtils.decodeUUID(decoder);
        return new PassiveReplicationMessage.ClientIDTrackerMessage(msgId, clientId);
    }

    private static UUID getClientId(ByteBuffer payload) {
        long msb = payload.getLong();
        long lsb = payload.getLong();
        return new UUID(msb, lsb);
    }
}

