/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.messages;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.ehcache.clustered.common.internal.store.Chain;
import org.ehcache.clustered.common.internal.store.Element;
import org.ehcache.clustered.common.internal.store.SequencedElement;
import org.ehcache.clustered.common.internal.store.Util;
import org.terracotta.runnel.Struct;
import org.terracotta.runnel.StructBuilder;
import org.terracotta.runnel.decoding.StructArrayDecoder;
import org.terracotta.runnel.decoding.StructDecoder;
import org.terracotta.runnel.encoding.StructArrayEncoder;
import org.terracotta.runnel.encoding.StructEncoder;

public class ChainCodec {
    private static final Struct ELEMENT_STRUCT = StructBuilder.newStructBuilder().int64("sequence", 10).byteBuffer("payload", 20).build();
    static final Struct CHAIN_STRUCT = StructBuilder.newStructBuilder().structs("elements", 10, ELEMENT_STRUCT).build();

    public byte[] encode(Chain chain) {
        StructEncoder encoder = CHAIN_STRUCT.encoder();
        this.encode(encoder, chain);
        ByteBuffer byteBuffer = encoder.encode();
        return byteBuffer.array();
    }

    public void encode(StructEncoder encoder, Chain chain) {
        StructArrayEncoder elementsEncoder = encoder.structs("elements");
        for (Element element : chain) {
            if (element instanceof SequencedElement) {
                elementsEncoder.int64("sequence", ((SequencedElement)element).getSequenceNumber());
            }
            elementsEncoder.byteBuffer("payload", element.getPayload());
            elementsEncoder.next();
        }
    }

    public Chain decode(byte[] payload) {
        StructDecoder decoder = CHAIN_STRUCT.decoder(ByteBuffer.wrap(payload));
        return this.decode(decoder);
    }

    public Chain decode(StructDecoder decoder) {
        StructArrayDecoder elementsDecoder = decoder.structs("elements");
        ArrayList<Element> elements = new ArrayList<Element>();
        for (int i = 0; i < elementsDecoder.length(); ++i) {
            Long sequence = elementsDecoder.int64("sequence");
            ByteBuffer byteBuffer = elementsDecoder.byteBuffer("payload");
            Element element = sequence != null ? Util.getElement(sequence, byteBuffer) : Util.getElement(byteBuffer);
            elements.add(element);
            elementsDecoder.next();
        }
        elementsDecoder.end();
        return Util.getChain(elements);
    }
}

