/*
 * Decompiled with CFR 0.152.
 */
package com.tc.bytes;

import com.tc.bytes.BufferPool;
import com.tc.bytes.TCByteBuffer;
import com.tc.bytes.TCByteBufferFactory;
import com.tc.util.Assert;
import com.tc.util.State;
import java.nio.ByteBuffer;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class TCByteBufferImpl
implements TCByteBuffer,
BufferPool {
    private static final State INIT = new State("INIT");
    private static final State CHECKED_OUT = new State("CHECKED_OUT");
    private static final State COMMITTED = new State("COMMITTED");
    private final ByteBuffer buffer;
    private final TCByteBuffer root;
    private final LinkedBlockingQueue<TCByteBuffer> bufPool;
    private State state = INIT;

    TCByteBufferImpl(int capacity, boolean direct, LinkedBlockingQueue<TCByteBuffer> poolQueue) {
        this.buffer = direct ? ByteBuffer.allocateDirect(capacity) : ByteBuffer.allocate(capacity);
        this.bufPool = poolQueue;
        this.root = this;
    }

    private TCByteBufferImpl(ByteBuffer buf) {
        this.buffer = buf;
        this.bufPool = null;
        this.root = null;
    }

    private TCByteBufferImpl(ByteBuffer buf, TCByteBuffer root) {
        this.buffer = buf;
        this.bufPool = null;
        this.root = root;
    }

    static TCByteBuffer wrap(byte[] data) {
        return new TCByteBufferImpl(ByteBuffer.wrap(data));
    }

    protected ByteBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    public TCByteBuffer clear() {
        this.buffer.clear();
        return this;
    }

    @Override
    public int capacity() {
        return this.buffer.capacity();
    }

    @Override
    public int position() {
        return this.buffer.position();
    }

    @Override
    public TCByteBuffer flip() {
        this.buffer.flip();
        return this;
    }

    @Override
    public boolean hasRemaining() {
        return this.buffer.hasRemaining();
    }

    @Override
    public int limit() {
        return this.buffer.limit();
    }

    @Override
    public TCByteBuffer limit(int newLimit) {
        this.buffer.limit(newLimit);
        return this;
    }

    @Override
    public TCByteBuffer position(int newPosition) {
        this.buffer.position(newPosition);
        return this;
    }

    @Override
    public int remaining() {
        return this.buffer.remaining();
    }

    @Override
    public TCByteBuffer rewind() {
        this.buffer.rewind();
        return this;
    }

    @Override
    public ByteBuffer getNioBuffer() {
        return this.buffer;
    }

    @Override
    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    @Override
    public byte[] array() {
        return this.buffer.array();
    }

    @Override
    public byte get() {
        return this.buffer.get();
    }

    @Override
    public boolean getBoolean() {
        return this.buffer.get() > 0;
    }

    @Override
    public boolean getBoolean(int index) {
        return this.buffer.get(index) > 0;
    }

    @Override
    public char getChar() {
        return this.buffer.getChar();
    }

    @Override
    public char getChar(int index) {
        return this.buffer.getChar(index);
    }

    @Override
    public double getDouble() {
        return this.buffer.getDouble();
    }

    @Override
    public double getDouble(int index) {
        return this.buffer.getDouble(index);
    }

    @Override
    public float getFloat() {
        return this.buffer.getFloat();
    }

    @Override
    public float getFloat(int index) {
        return this.buffer.getFloat(index);
    }

    @Override
    public int getInt() {
        return this.buffer.getInt();
    }

    @Override
    public int getInt(int index) {
        return this.buffer.getInt(index);
    }

    @Override
    public long getLong() {
        return this.buffer.getLong();
    }

    @Override
    public long getLong(int index) {
        return this.buffer.getLong(index);
    }

    @Override
    public short getShort() {
        return this.buffer.getShort();
    }

    @Override
    public short getShort(int index) {
        return this.buffer.getShort(index);
    }

    @Override
    public TCByteBuffer get(byte[] dst) {
        this.buffer.get(dst);
        return this;
    }

    @Override
    public TCByteBuffer get(byte[] dst, int offset, int length) {
        this.buffer.get(dst, offset, length);
        return this;
    }

    @Override
    public byte get(int index) {
        return this.buffer.get(index);
    }

    @Override
    public TCByteBuffer put(byte b) {
        this.buffer.put(b);
        return this;
    }

    @Override
    public TCByteBuffer put(byte[] src) {
        this.buffer.put(src);
        return this;
    }

    @Override
    public TCByteBuffer put(byte[] src, int offset, int length) {
        this.buffer.put(src, offset, length);
        return this;
    }

    @Override
    public TCByteBuffer put(int index, byte b) {
        this.buffer.put(index, b);
        return this;
    }

    @Override
    public TCByteBuffer putBoolean(boolean b) {
        this.buffer.put(b ? (byte)1 : 0);
        return this;
    }

    @Override
    public TCByteBuffer putBoolean(int index, boolean b) {
        this.buffer.put(index, b ? (byte)1 : 0);
        return this;
    }

    @Override
    public TCByteBuffer putChar(char c) {
        this.buffer.putChar(c);
        return this;
    }

    @Override
    public TCByteBuffer putChar(int index, char c) {
        this.buffer.putChar(index, c);
        return this;
    }

    @Override
    public TCByteBuffer putDouble(double d) {
        this.buffer.putDouble(d);
        return this;
    }

    @Override
    public TCByteBuffer putDouble(int index, double d) {
        this.buffer.putDouble(index, d);
        return this;
    }

    @Override
    public TCByteBuffer putFloat(float f) {
        this.buffer.putFloat(f);
        return this;
    }

    @Override
    public TCByteBuffer putFloat(int index, float f) {
        this.buffer.putFloat(index, f);
        return this;
    }

    @Override
    public TCByteBuffer putInt(int i) {
        this.buffer.putInt(i);
        return this;
    }

    @Override
    public TCByteBuffer putInt(int index, int i) {
        this.buffer.putInt(index, i);
        return this;
    }

    @Override
    public TCByteBuffer putLong(long l) {
        this.buffer.putLong(l);
        return this;
    }

    @Override
    public TCByteBuffer putLong(int index, long l) {
        this.buffer.putLong(index, l);
        return this;
    }

    @Override
    public TCByteBuffer putShort(short s) {
        this.buffer.putShort(s);
        return this;
    }

    @Override
    public TCByteBuffer putShort(int index, short s) {
        this.buffer.putShort(index, s);
        return this;
    }

    @Override
    public TCByteBuffer duplicate() {
        return new TCByteBufferImpl(this.buffer.duplicate(), this.root);
    }

    @Override
    public TCByteBuffer put(TCByteBuffer src) {
        this.buffer.put(src.getNioBuffer());
        return this;
    }

    @Override
    public TCByteBuffer slice() {
        return new TCByteBufferImpl(this.buffer.slice(), this.root);
    }

    @Override
    public int arrayOffset() {
        return this.buffer.arrayOffset();
    }

    @Override
    public TCByteBuffer asReadOnlyBuffer() {
        return new TCByteBufferImpl(this.buffer.asReadOnlyBuffer(), this.root);
    }

    @Override
    public boolean isReadOnly() {
        return this.buffer.isReadOnly();
    }

    public String toString() {
        return this.buffer == null ? "TCByteBufferJDK14(null buffer)" : "TCByteBufferJDK14@" + System.identityHashCode(this) + "(" + this.buffer.toString() + ")";
    }

    @Override
    public boolean hasArray() {
        return this.buffer.hasArray();
    }

    @Override
    public void recycle() {
        if (this.root != null) {
            TCByteBufferFactory.returnBuffer(this.root.reInit());
        }
    }

    @Override
    public TCByteBuffer reInit() {
        this.clear();
        return this;
    }

    @Override
    public final TCByteBuffer get(int index, byte[] dst) {
        return this.get(index, dst, 0, dst.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final TCByteBuffer get(int index, byte[] dst, int offset, int length) {
        int origPosition = this.position();
        try {
            this.position(index);
            this.get(dst, offset, length);
        }
        finally {
            this.position(origPosition);
        }
        return this;
    }

    @Override
    public final TCByteBuffer put(int index, byte[] src) {
        return this.put(index, src, 0, src.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final TCByteBuffer put(int index, byte[] src, int offset, int length) {
        int origPosition = this.position();
        try {
            this.position(index);
            this.put(src, offset, length);
        }
        finally {
            this.position(origPosition);
        }
        return this;
    }

    @Override
    public final TCByteBuffer putUint(long i) {
        if (i > 0xFFFFFFFFL || i < 0L) {
            throw new IllegalArgumentException("Unsigned integer value must be positive and <= (2^32)-1");
        }
        this.put((byte)(i >> 24 & 0xFFL));
        this.put((byte)(i >> 16 & 0xFFL));
        this.put((byte)(i >> 8 & 0xFFL));
        this.put((byte)(i & 0xFFL));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final TCByteBuffer putUint(int index, long i) {
        int origPosition = this.position();
        try {
            this.position(index);
            this.putUint(i);
        }
        finally {
            this.position(origPosition);
        }
        return this;
    }

    @Override
    public final TCByteBuffer putUshort(int s) {
        if (s > 65535 || s < 0) {
            throw new IllegalArgumentException("Unsigned integer value must be positive and <= (2^16)-1");
        }
        this.put((byte)(s >> 8 & 0xFF));
        this.put((byte)(s & 0xFF));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final TCByteBuffer putUshort(int index, int s) {
        int origPosition = this.position();
        try {
            this.position(index);
            this.putUshort(s);
        }
        finally {
            this.position(origPosition);
        }
        return this;
    }

    @Override
    public final long getUint() {
        long rv = 0L;
        rv += (long)(this.get() & 0xFF) << 24;
        rv += (long)((this.get() & 0xFF) << 16);
        rv += (long)((this.get() & 0xFF) << 8);
        return rv += (long)(this.get() & 0xFF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long getUint(int index) {
        int origPosition = this.position();
        try {
            this.position(index);
            long l = this.getUint();
            return l;
        }
        finally {
            this.position(origPosition);
        }
    }

    @Override
    public final int getUshort() {
        int rv = 0;
        rv += (this.get() & 0xFF) << 8;
        Assert.eval((rv += this.get() & 0xFF) >= 0 && rv <= 65535);
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getUshort(int index) {
        int origPosition = this.position();
        try {
            this.position(index);
            int n = this.getUshort();
            return n;
        }
        finally {
            this.position(origPosition);
        }
    }

    @Override
    public final short getUbyte() {
        return (short)(this.get() & 0xFF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final short getUbyte(int index) {
        int origPosition = this.position();
        try {
            this.position(index);
            short s = this.getUbyte();
            return s;
        }
        finally {
            this.position(origPosition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final TCByteBuffer putUbyte(int index, short value) {
        int origPosition = this.position();
        try {
            this.position(index);
            this.putUbyte(value);
        }
        finally {
            this.position(origPosition);
        }
        return this;
    }

    @Override
    public final TCByteBuffer putUbyte(short value) {
        if (value < 0 || value > 255) {
            throw new IllegalArgumentException("Unsigned byte value must in range 0-255 inclusive");
        }
        this.put((byte)(value & 0xFF));
        return this;
    }

    @Override
    public void commit() {
        if (this.state == COMMITTED) {
            throw new AssertionError((Object)"Already commited");
        }
        this.state = COMMITTED;
    }

    @Override
    public void checkedOut() {
        if (this.state == CHECKED_OUT) {
            throw new AssertionError((Object)"Already checked out");
        }
        this.state = CHECKED_OUT;
    }

    @Override
    public BufferPool getBufferPool() {
        return this;
    }

    @Override
    public void offer(TCByteBuffer buf) throws InterruptedException {
        this.bufPool.offer(buf, 0L, TimeUnit.MILLISECONDS);
    }
}

