/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.locks;

import com.tc.net.GroupID;
import com.tc.net.OrderedGroupIDs;
import com.tc.object.locks.LockDistributionStrategy;
import com.tc.object.locks.LockID;
import com.tc.object.locks.Notify;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

public class EnterpriseLockDistributionStrategy
implements LockDistributionStrategy {
    private final GroupID[] groupIDs;

    public EnterpriseLockDistributionStrategy(OrderedGroupIDs orderedGroupIDs) {
        this.groupIDs = orderedGroupIDs.getGroupIDs();
    }

    @Override
    public GroupID getGroupIDFor(LockID lock) {
        int hash = EnterpriseLockDistributionStrategy.hash(lock.hashCode());
        return this.groupIDs[Math.abs(hash % this.groupIDs.length)];
    }

    public SortedMap<GroupID, List<Notify>> segregateNotifies2Groups(List<Notify> notifies) {
        TreeMap<GroupID, List<Notify>> groupIds2Notifies = new TreeMap<GroupID, List<Notify>>();
        for (Notify notify : notifies) {
            GroupID gid = this.getGroupIDFor(notify.getLockID());
            List<Notify> list = groupIds2Notifies.get(gid);
            if (list == null) {
                list = new ArrayList<Notify>();
                groupIds2Notifies.put(gid, list);
            }
            list.add(notify);
        }
        return groupIds2Notifies;
    }

    private static int hash(int h) {
        h += h << 15 ^ 0xFFFFCD7D;
        h ^= h >>> 10;
        h += h << 3;
        h ^= h >>> 6;
        h += (h << 2) + (h << 14);
        return h ^ h >>> 16;
    }
}

