/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.config;

import org.ehcache.clustered.client.config.ClusteredResourceType;
import org.ehcache.clustered.client.config.SharedClusteredResourcePool;
import org.ehcache.clustered.common.PoolAllocation;
import org.ehcache.core.config.AbstractResourcePool;

public class SharedClusteredResourcePoolImpl
extends AbstractResourcePool<SharedClusteredResourcePool, ClusteredResourceType<SharedClusteredResourcePool>>
implements SharedClusteredResourcePool {
    private final String sharedResourcePool;

    public SharedClusteredResourcePoolImpl(String sharedResourcePool) {
        super(ClusteredResourceType.Types.SHARED, true);
        if (sharedResourcePool == null) {
            throw new NullPointerException("sharedResourcePool identifier can not be null");
        }
        this.sharedResourcePool = sharedResourcePool;
    }

    public ClusteredResourceType<SharedClusteredResourcePool> getType() {
        return (ClusteredResourceType)super.getType();
    }

    @Override
    public String getSharedResourcePool() {
        return this.sharedResourcePool;
    }

    @Override
    public PoolAllocation getPoolAllocation() {
        return new PoolAllocation.Shared(this.getSharedResourcePool());
    }

    public String toString() {
        return "Pool {sharedResourcePool='" + this.sharedResourcePool + '\'' + " " + this.getType() + (this.isPersistent() ? "(persistent)}" : "}");
    }
}

