/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.msg;

import com.tc.async.api.OrderedEventContext;
import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.l2.msg.ReplicationEnvelope;
import com.tc.net.ClientID;
import com.tc.net.NodeID;
import com.tc.net.groups.AbstractGroupMessage;
import com.tc.object.ClientInstanceID;
import com.tc.object.EntityDescriptor;
import com.tc.object.EntityID;
import com.tc.object.tx.TransactionID;
import com.tc.util.Assert;
import java.io.IOException;

public class ReplicationMessage
extends AbstractGroupMessage
implements OrderedEventContext {
    public static final int INVALID = 0;
    public static final int REPLICATE = 1;
    public static final int SYNC = 2;
    public static final int START = 3;
    EntityDescriptor descriptor;
    ClientID src;
    TransactionID tid;
    TransactionID oldest;
    ReplicationType action;
    byte[] payload;
    int concurrency;
    long rid = 0L;
    String debugId;

    public static ReplicationMessage createStartMessage() {
        return new ReplicationMessage(3);
    }

    public static ReplicationMessage createNoOpMessage(EntityID eid, long version) {
        return new ReplicationMessage(new EntityDescriptor(eid, ClientInstanceID.NULL_ID, version), ClientID.NULL_ID, TransactionID.NULL_ID, TransactionID.NULL_ID, ReplicationType.NOOP, new byte[0], 0, "");
    }

    public static ReplicationMessage createReplicatedMessage(EntityDescriptor descriptor, ClientID src, TransactionID tid, TransactionID oldest, ReplicationType action, byte[] payload, int concurrency, String debugId) {
        return new ReplicationMessage(descriptor, src, tid, oldest, action, payload, concurrency, debugId);
    }

    public ReplicationMessage() {
        super(0);
        this.descriptor = new EntityDescriptor(EntityID.NULL_ID, ClientInstanceID.NULL_ID, 0L);
    }

    protected ReplicationMessage(int type) {
        super(type);
    }

    private ReplicationMessage(EntityDescriptor descriptor, ClientID src, TransactionID tid, TransactionID oldest, ReplicationType action, byte[] payload, int concurrency, String debugId) {
        super(action.ordinal() >= ReplicationType.SYNC_BEGIN.ordinal() ? 2 : 1);
        this.initialize(descriptor, src, tid, oldest, action, payload, concurrency, debugId);
    }

    protected final void initialize(EntityDescriptor descriptor, ClientID src, TransactionID tid, TransactionID oldest, ReplicationType action, byte[] payload, int concurrency, String debugId) {
        Assert.assertNotNull(tid);
        Assert.assertNotNull(oldest);
        Assert.assertNotNull(src);
        this.descriptor = descriptor;
        this.src = src;
        this.tid = tid;
        this.oldest = oldest;
        this.action = action;
        this.payload = payload;
        this.concurrency = concurrency;
        this.debugId = debugId;
    }

    public ReplicationEnvelope target(NodeID node) {
        return new ReplicationEnvelope(node, this, null);
    }

    public ReplicationEnvelope target(NodeID node, Runnable waitRelease) {
        return new ReplicationEnvelope(node, this, waitRelease);
    }

    public void setReplicationID(long rid) {
        this.rid = rid;
    }

    public void setNoop() {
        this.action = ReplicationType.NOOP;
    }

    @Override
    public long getSequenceID() {
        return this.rid;
    }

    public long getVersion() {
        return this.descriptor.getClientSideVersion();
    }

    public ReplicationType getReplicationType() {
        return this.action;
    }

    public byte[] getExtendedData() {
        return this.payload;
    }

    public ClientID getSource() {
        return this.src;
    }

    public TransactionID getTransactionID() {
        return this.tid;
    }

    public TransactionID getOldestTransactionOnClient() {
        return this.oldest;
    }

    public EntityDescriptor getEntityDescriptor() {
        return this.descriptor;
    }

    public EntityID getEntityID() {
        return this.descriptor == null ? EntityID.NULL_ID : this.descriptor.getEntityID();
    }

    public int getConcurrency() {
        return this.concurrency;
    }

    @Override
    protected void basicDeserializeFrom(TCByteBufferInput in) throws IOException {
        int messageType = this.getType();
        switch (messageType) {
            case 0: {
                Assert.fail();
                break;
            }
            case 3: {
                break;
            }
            case 1: 
            case 2: {
                this.rid = in.readLong();
                this.descriptor = EntityDescriptor.readFrom(in);
                int type = in.read();
                if (type == 1) {
                    this.src = new ClientID().deserializeFrom(in);
                } else if (type == 2) {
                    throw new AssertionError((Object)"node type is incorrect");
                }
                this.tid = new TransactionID(in.readLong());
                this.oldest = new TransactionID(in.readLong());
                this.action = ReplicationType.values()[in.readInt()];
                int length = in.readInt();
                this.payload = new byte[length];
                in.readFully(this.payload);
                this.concurrency = in.readInt();
            }
        }
    }

    @Override
    protected void basicSerializeTo(TCByteBufferOutput out) {
        int messageType = this.getType();
        switch (messageType) {
            case 0: {
                Assert.fail();
                break;
            }
            case 3: {
                break;
            }
            case 1: 
            case 2: {
                out.writeLong(this.rid);
                this.descriptor.serializeTo(out);
                out.write(this.src.getNodeType());
                this.src.serializeTo(out);
                out.writeLong(this.tid.toLong());
                out.writeLong(this.oldest.toLong());
                out.writeInt(this.action.ordinal());
                if (this.payload != null) {
                    out.writeInt(this.payload.length);
                    out.write(this.payload);
                } else {
                    out.writeInt(0);
                }
                out.writeInt(this.concurrency);
            }
        }
    }

    public String toString() {
        return "ReplicationMessage{rid=" + this.rid + ", id=" + this.descriptor.getEntityID() + ", src=" + this.src + ", tid=" + this.tid + ", oldest=" + this.oldest + ", action=" + (Object)((Object)this.action) + ", concurrency=" + this.concurrency + ", debug=" + this.debugId + '}';
    }

    public static enum ReplicationType {
        NOOP,
        CREATE_ENTITY,
        RECONFIGURE_ENTITY,
        INVOKE_ACTION,
        DESTROY_ENTITY,
        SYNC_BEGIN,
        SYNC_END,
        SYNC_ENTITY_BEGIN,
        SYNC_ENTITY_END,
        SYNC_ENTITY_CONCURRENCY_BEGIN,
        SYNC_ENTITY_CONCURRENCY_PAYLOAD,
        SYNC_ENTITY_CONCURRENCY_END;

    }
}

