/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.messages;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.ehcache.clustered.common.internal.messages.ChainCodec;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityMessage;
import org.ehcache.clustered.common.internal.messages.EhcacheMessageType;
import org.ehcache.clustered.common.internal.messages.MessageCodecUtils;
import org.ehcache.clustered.common.internal.messages.ServerStoreOpMessage;
import org.ehcache.clustered.common.internal.store.Chain;
import org.terracotta.runnel.Struct;
import org.terracotta.runnel.StructBuilder;
import org.terracotta.runnel.decoding.StructDecoder;
import org.terracotta.runnel.encoding.StructEncoder;
import org.terracotta.runnel.encoding.StructEncoderFunction;

class ServerStoreOpCodec {
    private static final Struct GET_AND_APPEND_MESSAGE_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, EhcacheMessageType.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).int64("msgId", 15).int64("msbUUID", 20).int64("lsbUUID", 21).string("serverStoreName", 30).int64("key", 40).byteBuffer("payload", 50).build();
    private static final Struct APPEND_MESSAGE_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, EhcacheMessageType.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).int64("msgId", 15).int64("msbUUID", 20).int64("lsbUUID", 21).string("serverStoreName", 30).int64("key", 40).byteBuffer("payload", 50).build();
    private static final Struct REPLACE_MESSAGE_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, EhcacheMessageType.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).int64("msgId", 15).int64("msbUUID", 20).int64("lsbUUID", 21).string("serverStoreName", 30).int64("key", 40).struct("expect", 50, ChainCodec.CHAIN_STRUCT).struct("update", 60, ChainCodec.CHAIN_STRUCT).build();
    private static final Struct CLIENT_INVALIDATION_ACK_MESSAGE_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, EhcacheMessageType.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).int64("msgId", 15).string("serverStoreName", 30).int32("invalidationId", 40).build();
    private static final Struct CLEAR_MESSAGE_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, EhcacheMessageType.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).int64("msgId", 15).int64("msbUUID", 20).int64("lsbUUID", 21).string("serverStoreName", 30).build();
    private static final Struct GET_MESSAGE_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, EhcacheMessageType.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).int64("msgId", 15).string("serverStoreName", 30).int64("key", 40).build();
    private final ChainCodec chainCodec;
    private final MessageCodecUtils messageCodecUtils = new MessageCodecUtils();

    ServerStoreOpCodec() {
        this.chainCodec = new ChainCodec();
    }

    public byte[] encode(ServerStoreOpMessage message) {
        StructEncoder encoder = null;
        switch (message.getMessageType()) {
            case GET_STORE: {
                ServerStoreOpMessage.GetMessage getMessage = (ServerStoreOpMessage.GetMessage)message;
                encoder = GET_MESSAGE_STRUCT.encoder();
                return ((StructEncoder)encoder.enm("opCode", (Object)message.getMessageType())).int64("msgId", message.getId()).string("serverStoreName", getMessage.getCacheId()).int64("key", getMessage.getKey()).encode().array();
            }
            case APPEND: {
                ServerStoreOpMessage.AppendMessage appendMessage = (ServerStoreOpMessage.AppendMessage)message;
                encoder = APPEND_MESSAGE_STRUCT.encoder();
                this.messageCodecUtils.encodeMandatoryFields(encoder, message);
                return encoder.string("serverStoreName", appendMessage.getCacheId()).int64("key", appendMessage.getKey()).byteBuffer("payload", appendMessage.getPayload()).encode().array();
            }
            case GET_AND_APPEND: {
                ServerStoreOpMessage.GetAndAppendMessage getAndAppendMessage = (ServerStoreOpMessage.GetAndAppendMessage)message;
                encoder = GET_AND_APPEND_MESSAGE_STRUCT.encoder();
                this.messageCodecUtils.encodeMandatoryFields(encoder, message);
                return encoder.string("serverStoreName", getAndAppendMessage.getCacheId()).int64("key", getAndAppendMessage.getKey()).byteBuffer("payload", getAndAppendMessage.getPayload()).encode().array();
            }
            case REPLACE: {
                final ServerStoreOpMessage.ReplaceAtHeadMessage replaceAtHeadMessage = (ServerStoreOpMessage.ReplaceAtHeadMessage)message;
                encoder = REPLACE_MESSAGE_STRUCT.encoder();
                this.messageCodecUtils.encodeMandatoryFields(encoder, message);
                return encoder.string("serverStoreName", replaceAtHeadMessage.getCacheId()).int64("key", replaceAtHeadMessage.getKey()).struct("expect", new StructEncoderFunction(){

                    @Override
                    public void encode(StructEncoder encoder) {
                        Chain expect = replaceAtHeadMessage.getExpect();
                        ServerStoreOpCodec.this.chainCodec.encode(encoder, expect);
                    }
                }).struct("update", new StructEncoderFunction(){

                    @Override
                    public void encode(StructEncoder encoder) {
                        Chain update = replaceAtHeadMessage.getUpdate();
                        ServerStoreOpCodec.this.chainCodec.encode(encoder, update);
                    }
                }).encode().array();
            }
            case CLIENT_INVALIDATION_ACK: {
                ServerStoreOpMessage.ClientInvalidationAck clientInvalidationAckMessage = (ServerStoreOpMessage.ClientInvalidationAck)message;
                encoder = CLIENT_INVALIDATION_ACK_MESSAGE_STRUCT.encoder();
                return ((StructEncoder)encoder.enm("opCode", (Object)message.getMessageType())).int64("msgId", message.getId()).string("serverStoreName", clientInvalidationAckMessage.getCacheId()).int32("invalidationId", clientInvalidationAckMessage.getInvalidationId()).encode().array();
            }
            case CLEAR: {
                ServerStoreOpMessage.ClearMessage clearMessage = (ServerStoreOpMessage.ClearMessage)message;
                encoder = CLEAR_MESSAGE_STRUCT.encoder();
                this.messageCodecUtils.encodeMandatoryFields(encoder, message);
                return encoder.string("serverStoreName", clearMessage.getCacheId()).encode().array();
            }
        }
        throw new RuntimeException("Unhandled message operation : " + (Object)((Object)message.getMessageType()));
    }

    public EhcacheEntityMessage decode(EhcacheMessageType opCode, ByteBuffer messageBuffer) {
        switch (opCode) {
            case GET_STORE: {
                StructDecoder decoder = GET_MESSAGE_STRUCT.decoder(messageBuffer);
                Long msgId = decoder.int64("msgId");
                String cacheId = decoder.string("serverStoreName");
                Long key = decoder.int64("key");
                ServerStoreOpMessage.GetMessage message = new ServerStoreOpMessage.GetMessage(cacheId, key);
                message.setId(msgId);
                return message;
            }
            case GET_AND_APPEND: {
                StructDecoder decoder = GET_AND_APPEND_MESSAGE_STRUCT.decoder(messageBuffer);
                Long msgId = decoder.int64("msgId");
                UUID uuid = this.messageCodecUtils.decodeUUID(decoder);
                String cacheId = decoder.string("serverStoreName");
                Long key = decoder.int64("key");
                ByteBuffer payload = decoder.byteBuffer("payload");
                ServerStoreOpMessage.GetAndAppendMessage message = new ServerStoreOpMessage.GetAndAppendMessage(cacheId, key, payload, uuid);
                message.setId(msgId);
                return message;
            }
            case APPEND: {
                StructDecoder decoder = APPEND_MESSAGE_STRUCT.decoder(messageBuffer);
                Long msgId = decoder.int64("msgId");
                UUID uuid = this.messageCodecUtils.decodeUUID(decoder);
                String cacheId = decoder.string("serverStoreName");
                Long key = decoder.int64("key");
                ByteBuffer payload = decoder.byteBuffer("payload");
                ServerStoreOpMessage.AppendMessage message = new ServerStoreOpMessage.AppendMessage(cacheId, key, payload, uuid);
                message.setId(msgId);
                return message;
            }
            case REPLACE: {
                StructDecoder decoder = REPLACE_MESSAGE_STRUCT.decoder(messageBuffer);
                Long msgId = decoder.int64("msgId");
                UUID uuid = this.messageCodecUtils.decodeUUID(decoder);
                String cacheId = decoder.string("serverStoreName");
                Long key = decoder.int64("key");
                Chain expect = this.chainCodec.decode(decoder.struct("expect"));
                Chain update = this.chainCodec.decode(decoder.struct("update"));
                ServerStoreOpMessage.ReplaceAtHeadMessage message = new ServerStoreOpMessage.ReplaceAtHeadMessage(cacheId, key, expect, update, uuid);
                message.setId(msgId);
                return message;
            }
            case CLIENT_INVALIDATION_ACK: {
                StructDecoder decoder = CLIENT_INVALIDATION_ACK_MESSAGE_STRUCT.decoder(messageBuffer);
                Long msgId = decoder.int64("msgId");
                String cacheId = decoder.string("serverStoreName");
                Integer invalidationId = decoder.int32("invalidationId");
                ServerStoreOpMessage.ClientInvalidationAck message = new ServerStoreOpMessage.ClientInvalidationAck(cacheId, invalidationId);
                message.setId(msgId);
                return message;
            }
            case CLEAR: {
                StructDecoder decoder = CLEAR_MESSAGE_STRUCT.decoder(messageBuffer);
                Long msgId = decoder.int64("msgId");
                UUID uuid = this.messageCodecUtils.decodeUUID(decoder);
                String cacheId = decoder.string("serverStoreName");
                ServerStoreOpMessage.ClearMessage message = new ServerStoreOpMessage.ClearMessage(cacheId, uuid);
                message.setId(msgId);
                return message;
            }
        }
        throw new RuntimeException("Unhandled message operation : " + (Object)((Object)opCode));
    }
}

