/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.lease;

import org.terracotta.entity.EndpointDelegate;
import org.terracotta.lease.LeaseAcquirerAvailable;
import org.terracotta.lease.LeaseReconnectData;
import org.terracotta.lease.LeaseReconnectDataSupplier;
import org.terracotta.lease.LeaseReconnectListener;
import org.terracotta.lease.LeaseResponse;

class LeaseEndpointDelegate
implements EndpointDelegate<LeaseResponse> {
    private final LeaseReconnectListener reconnectListener;
    private final LeaseReconnectDataSupplier reconnectDataSupplier;

    public LeaseEndpointDelegate(LeaseReconnectListener reconnectListener, LeaseReconnectDataSupplier reconnectDataSupplier) {
        this.reconnectListener = reconnectListener;
        this.reconnectDataSupplier = reconnectDataSupplier;
    }

    @Override
    public void handleMessage(LeaseResponse entityResponse) {
        if (!(entityResponse instanceof LeaseAcquirerAvailable)) {
            throw new AssertionError((Object)("Received unexpected message from server: " + String.valueOf(entityResponse)));
        }
        this.reconnectListener.reconnected();
    }

    @Override
    public byte[] createExtendedReconnectData() {
        this.reconnectListener.reconnecting();
        LeaseReconnectData reconnectData = this.reconnectDataSupplier.getReconnectData();
        return reconnectData.encode();
    }

    @Override
    public void didDisconnectUnexpectedly() {
    }
}

