/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.service;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.terracotta.dynamic_config.api.model.ConfigFormat;
import org.terracotta.dynamic_config.api.service.ConfigPropertiesTranslator;
import org.terracotta.dynamic_config.api.service.Props;

public interface ConfigSource {
    public ConfigFormat getConfigFormat();

    public Properties getConfigProperties();

    public static ConfigSource from(String input) {
        if (input.equals("-")) {
            return ConfigSource.from(new InputStreamReader(System.in, StandardCharsets.UTF_8));
        }
        return ConfigSource.from(Paths.get(input, new String[0]));
    }

    public static ConfigSource from(final Path path) {
        final ConfigFormat format = ConfigFormat.from(path);
        return new ConfigSource(){

            @Override
            public ConfigFormat getConfigFormat() {
                return format;
            }

            @Override
            public Properties getConfigProperties() {
                switch (format) {
                    case PROPERTIES: {
                        return Props.load(path);
                    }
                    case CONFIG: {
                        return new ConfigPropertiesTranslator().load(path);
                    }
                }
                throw new IllegalArgumentException("Invalid format: " + String.valueOf((Object)format) + ". Supported formats: " + String.join((CharSequence)", ", ConfigFormat.supported()));
            }

            public String toString() {
                return path.toString();
            }
        };
    }

    public static ConfigSource from(final Reader reader) {
        return new ConfigSource(){

            @Override
            public ConfigFormat getConfigFormat() {
                return ConfigFormat.CONFIG;
            }

            @Override
            public Properties getConfigProperties() {
                try {
                    return new ConfigPropertiesTranslator().convert(reader);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            public String toString() {
                return "-";
            }
        };
    }
}

