/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.common.struct;

import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public class Tuple2<T1, T2> {
    public final T1 t1;
    public final T2 t2;

    private Tuple2(T1 t1, T2 t2) {
        this.t1 = t1;
        this.t2 = t2;
    }

    public static <T1, T2> Tuple2<T1, T2> tuple2(T1 t1, T2 t2) {
        return new Tuple2<T1, T2>(t1, t2);
    }

    public T1 getT1() {
        return this.t1;
    }

    public T2 getT2() {
        return this.t2;
    }

    public Optional<T1> findT1() {
        return Optional.ofNullable(this.t1);
    }

    public Optional<T2> findT2() {
        return Optional.ofNullable(this.t2);
    }

    public <R1, R2> Tuple2<R1, R2> map(Function<T1, R1> fn1, Function<T2, R2> fn2) {
        return Tuple2.tuple2(fn1.apply(this.t1), fn2.apply(this.t2));
    }

    public Tuple2<T1, T2> ifAllPresent(Consumer<Tuple2<T1, T2>> c) {
        if (this.t1 != null && this.t2 != null) {
            c.accept(this);
        }
        return this;
    }

    public void accept(BiConsumer<T1, T2> consumer) {
        consumer.accept(this.t1, this.t2);
    }

    public boolean allNulls() {
        return this.t1 == null && this.t2 == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tuple2 tuple2 = (Tuple2)o;
        return Objects.deepEquals(this.t1, tuple2.t1) && Objects.deepEquals(this.t2, tuple2.t2);
    }

    public int hashCode() {
        return Objects.hash(this.t1, this.t2);
    }

    public String toString() {
        return "(" + String.valueOf(this.t1) + ", " + String.valueOf(this.t2) + ")";
    }
}

