/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.store.operations;

import java.nio.ByteBuffer;
import org.ehcache.clustered.common.internal.store.operations.LazyValueHolder;
import org.ehcache.clustered.common.internal.store.operations.Operation;
import org.ehcache.clustered.common.internal.store.operations.OperationCode;
import org.ehcache.clustered.common.internal.store.operations.codecs.CodecException;
import org.ehcache.spi.serialization.Serializer;

abstract class BaseKeyValueOperation<K, V>
implements Operation<K, V> {
    private final K key;
    private final LazyValueHolder<V> valueHolder;
    private final long timeStamp;

    BaseKeyValueOperation(K key, V value, long timeStamp) {
        if (key == null) {
            throw new NullPointerException("Key can not be null");
        }
        if (value == null) {
            throw new NullPointerException("Value can not be null");
        }
        this.key = key;
        this.valueHolder = new LazyValueHolder<V>(value);
        this.timeStamp = timeStamp;
    }

    BaseKeyValueOperation(BaseKeyValueOperation<K, V> copy, long timeStamp) {
        this.key = copy.key;
        this.valueHolder = copy.valueHolder;
        this.timeStamp = timeStamp;
    }

    BaseKeyValueOperation(ByteBuffer buffer, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        OperationCode opCode = OperationCode.valueOf(buffer.get());
        if (opCode != this.getOpCode()) {
            throw new IllegalArgumentException("Invalid operation: " + String.valueOf((Object)opCode));
        }
        this.timeStamp = buffer.getLong();
        int keySize = buffer.getInt();
        int maxLimit = buffer.limit();
        buffer.limit(buffer.position() + keySize);
        ByteBuffer keyBlob = buffer.slice();
        buffer.position(buffer.limit());
        buffer.limit(maxLimit);
        try {
            this.key = keySerializer.read(keyBlob);
        }
        catch (ClassNotFoundException e) {
            throw new CodecException(e);
        }
        this.valueHolder = new LazyValueHolder<V>(buffer.slice(), valueSerializer);
    }

    @Override
    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.valueHolder.getValue();
    }

    @Override
    public ByteBuffer encode(Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        ByteBuffer keyBuf = keySerializer.serialize(this.key);
        ByteBuffer valueBuf = this.valueHolder.encode(valueSerializer);
        int size = 13 + keyBuf.remaining() + valueBuf.remaining();
        ByteBuffer buffer = ByteBuffer.allocate(size);
        buffer.put(this.getOpCode().getValue());
        buffer.putLong(this.timeStamp);
        buffer.putInt(keyBuf.remaining());
        buffer.put(keyBuf);
        buffer.put(valueBuf);
        buffer.flip();
        return buffer;
    }

    public String toString() {
        return "{" + String.valueOf((Object)this.getOpCode()) + "# key: " + String.valueOf(this.key) + ", value: " + String.valueOf(this.getValue()) + "}";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BaseKeyValueOperation)) {
            return false;
        }
        BaseKeyValueOperation other = (BaseKeyValueOperation)obj;
        if (this.getOpCode() != other.getOpCode()) {
            return false;
        }
        if (!this.getKey().equals(other.getKey())) {
            return false;
        }
        return this.getValue().equals(other.getValue());
    }

    public int hashCode() {
        int hash = this.getOpCode().hashCode();
        hash = hash * 31 + this.key.hashCode();
        hash = hash * 31 + this.getValue().hashCode();
        return hash;
    }

    @Override
    public long timeStamp() {
        if (!this.isExpiryAvailable()) {
            return this.timeStamp;
        }
        throw new RuntimeException("Timestamp not available");
    }

    @Override
    public boolean isExpiryAvailable() {
        return this.timeStamp < 0L;
    }

    @Override
    public long expirationTime() {
        if (this.isExpiryAvailable()) {
            return -this.timeStamp;
        }
        throw new RuntimeException("Expiry not available");
    }
}

