/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.messages;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import org.ehcache.clustered.common.internal.exceptions.ClusterException;
import org.ehcache.clustered.common.internal.messages.BaseCodec;
import org.ehcache.clustered.common.internal.messages.ChainCodec;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityResponse;
import org.ehcache.clustered.common.internal.messages.EhcacheResponseType;
import org.ehcache.clustered.common.internal.messages.ExceptionCodec;
import org.ehcache.clustered.common.internal.messages.StateRepositoryOpCodec;
import org.ehcache.clustered.common.internal.store.Chain;
import org.ehcache.clustered.common.internal.store.Util;
import org.terracotta.runnel.Struct;
import org.terracotta.runnel.StructBuilder;
import org.terracotta.runnel.decoding.ArrayDecoder;
import org.terracotta.runnel.decoding.Enm;
import org.terracotta.runnel.decoding.StructArrayDecoder;
import org.terracotta.runnel.decoding.StructDecoder;
import org.terracotta.runnel.encoding.ArrayEncoder;
import org.terracotta.runnel.encoding.PrimitiveEncodingSupport;
import org.terracotta.runnel.encoding.StructEncoder;

public class ResponseCodec {
    private static final String EXCEPTION_FIELD = "exception";
    private static final String INVALIDATION_ID_FIELD = "invalidationId";
    private static final String CHAIN_FIELD = "chain";
    private static final String APPENDED_FIELD = "appended";
    private static final String MAP_VALUE_FIELD = "mapValue";
    private static final String STORES_FIELD = "stores";
    private static final Struct SUCCESS_RESPONSE_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, BaseCodec.EHCACHE_RESPONSE_TYPES_ENUM_MAPPING).build();
    private static final Struct FAILURE_RESPONSE_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, BaseCodec.EHCACHE_RESPONSE_TYPES_ENUM_MAPPING).struct("exception", 20, ExceptionCodec.EXCEPTION_STRUCT).build();
    private static final Struct GET_RESPONSE_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, BaseCodec.EHCACHE_RESPONSE_TYPES_ENUM_MAPPING).struct("chain", 20, ChainCodec.CHAIN_STRUCT).build();
    private static final Struct HASH_INVALIDATION_DONE_RESPONSE_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, BaseCodec.EHCACHE_RESPONSE_TYPES_ENUM_MAPPING).int64("key", 20).build();
    private static final Struct ALL_INVALIDATION_DONE_RESPONSE_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, BaseCodec.EHCACHE_RESPONSE_TYPES_ENUM_MAPPING).build();
    private static final Struct CLIENT_INVALIDATE_HASH_RESPONSE_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, BaseCodec.EHCACHE_RESPONSE_TYPES_ENUM_MAPPING).int64("key", 20).int32("invalidationId", 30).build();
    private static final Struct CLIENT_INVALIDATE_ALL_RESPONSE_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, BaseCodec.EHCACHE_RESPONSE_TYPES_ENUM_MAPPING).int32("invalidationId", 20).build();
    private static final Struct SERVER_INVALIDATE_HASH_RESPONSE_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, BaseCodec.EHCACHE_RESPONSE_TYPES_ENUM_MAPPING).int64("key", 20).struct("chain", 30, ChainCodec.CHAIN_STRUCT).build();
    private static final Struct SERVER_APPEND_RESPONSE_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, BaseCodec.EHCACHE_RESPONSE_TYPES_ENUM_MAPPING).byteBuffer("appended", 20).struct("chain", 30, ChainCodec.CHAIN_STRUCT).build();
    private static final Struct MAP_VALUE_RESPONSE_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, BaseCodec.EHCACHE_RESPONSE_TYPES_ENUM_MAPPING).byteBuffer("mapValue", 20).build();
    private static final Struct PREPARE_FOR_DESTROY_RESPONSE_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, BaseCodec.EHCACHE_RESPONSE_TYPES_ENUM_MAPPING).strings("stores", 20).build();
    private static final Struct RESOLVE_REQUEST_RESPONSE_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, BaseCodec.EHCACHE_RESPONSE_TYPES_ENUM_MAPPING).int64("key", 20).struct("chain", 30, ChainCodec.CHAIN_STRUCT).build();
    private static final Struct LOCK_RESPONSE_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, BaseCodec.EHCACHE_RESPONSE_TYPES_ENUM_MAPPING).struct("chain", 20, ChainCodec.CHAIN_STRUCT).build();
    private static final Struct ITERATOR_BATCH_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, BaseCodec.EHCACHE_RESPONSE_TYPES_ENUM_MAPPING).string("id", 20).structs("chains", 30, ChainCodec.CHAIN_ENTRY_STRUCT).bool("last", 40).build();

    public byte[] encode(EhcacheEntityResponse response) {
        switch (response.getResponseType()) {
            case FAILURE: {
                EhcacheEntityResponse.Failure failure = (EhcacheEntityResponse.Failure)response;
                return ((StructEncoder)FAILURE_RESPONSE_STRUCT.encoder().enm("opCode", (Object)failure.getResponseType())).struct(EXCEPTION_FIELD, failure.getCause(), ExceptionCodec::encode).encode().array();
            }
            case SUCCESS: {
                return ((StructEncoder)SUCCESS_RESPONSE_STRUCT.encoder().enm("opCode", (Object)response.getResponseType())).encode().array();
            }
            case GET_RESPONSE: {
                EhcacheEntityResponse.GetResponse getResponse = (EhcacheEntityResponse.GetResponse)response;
                return ((StructEncoder)GET_RESPONSE_STRUCT.encoder().enm("opCode", (Object)getResponse.getResponseType())).struct(CHAIN_FIELD, getResponse.getChain(), ChainCodec::encodeChain).encode().array();
            }
            case HASH_INVALIDATION_DONE: {
                EhcacheEntityResponse.HashInvalidationDone hashInvalidationDone = (EhcacheEntityResponse.HashInvalidationDone)response;
                return ((StructEncoder)((StructEncoder)HASH_INVALIDATION_DONE_RESPONSE_STRUCT.encoder().enm("opCode", (Object)hashInvalidationDone.getResponseType())).int64("key", hashInvalidationDone.getKey())).encode().array();
            }
            case ALL_INVALIDATION_DONE: {
                EhcacheEntityResponse.AllInvalidationDone allInvalidationDone = (EhcacheEntityResponse.AllInvalidationDone)response;
                return ((StructEncoder)ALL_INVALIDATION_DONE_RESPONSE_STRUCT.encoder().enm("opCode", (Object)allInvalidationDone.getResponseType())).encode().array();
            }
            case CLIENT_INVALIDATE_HASH: {
                EhcacheEntityResponse.ClientInvalidateHash clientInvalidateHash = (EhcacheEntityResponse.ClientInvalidateHash)response;
                return ((StructEncoder)((StructEncoder)((StructEncoder)CLIENT_INVALIDATE_HASH_RESPONSE_STRUCT.encoder().enm("opCode", (Object)clientInvalidateHash.getResponseType())).int64("key", clientInvalidateHash.getKey())).int32(INVALIDATION_ID_FIELD, clientInvalidateHash.getInvalidationId())).encode().array();
            }
            case CLIENT_INVALIDATE_ALL: {
                EhcacheEntityResponse.ClientInvalidateAll clientInvalidateAll = (EhcacheEntityResponse.ClientInvalidateAll)response;
                return ((StructEncoder)((StructEncoder)CLIENT_INVALIDATE_ALL_RESPONSE_STRUCT.encoder().enm("opCode", (Object)clientInvalidateAll.getResponseType())).int32(INVALIDATION_ID_FIELD, clientInvalidateAll.getInvalidationId())).encode().array();
            }
            case SERVER_APPEND: {
                EhcacheEntityResponse.ServerAppend serverAppend = (EhcacheEntityResponse.ServerAppend)response;
                return ((StructEncoder)((StructEncoder)SERVER_APPEND_RESPONSE_STRUCT.encoder().enm("opCode", (Object)serverAppend.getResponseType())).byteBuffer(APPENDED_FIELD, serverAppend.getAppended())).struct(CHAIN_FIELD, serverAppend.getBeforeAppend(), ChainCodec::encodeChain).encode().array();
            }
            case SERVER_INVALIDATE_HASH: {
                EhcacheEntityResponse.ServerInvalidateHash serverInvalidateHash = (EhcacheEntityResponse.ServerInvalidateHash)response;
                PrimitiveEncodingSupport encoder = ((StructEncoder)SERVER_INVALIDATE_HASH_RESPONSE_STRUCT.encoder().enm("opCode", (Object)serverInvalidateHash.getResponseType())).int64("key", serverInvalidateHash.getKey());
                if (serverInvalidateHash.getEvictedChain() != null) {
                    ((StructEncoder)encoder).struct(CHAIN_FIELD, serverInvalidateHash.getEvictedChain(), ChainCodec::encodeChain);
                }
                return ((StructEncoder)encoder).encode().array();
            }
            case MAP_VALUE: {
                EhcacheEntityResponse.MapValue mapValue = (EhcacheEntityResponse.MapValue)response;
                byte[] encodedMapValue = Util.marshall(mapValue.getValue());
                return ((StructEncoder)((StructEncoder)MAP_VALUE_RESPONSE_STRUCT.encoder().enm("opCode", (Object)mapValue.getResponseType())).byteBuffer(MAP_VALUE_FIELD, ByteBuffer.wrap(encodedMapValue))).encode().array();
            }
            case PREPARE_FOR_DESTROY: {
                EhcacheEntityResponse.PrepareForDestroy prepare = (EhcacheEntityResponse.PrepareForDestroy)response;
                PrimitiveEncodingSupport encoder = PREPARE_FOR_DESTROY_RESPONSE_STRUCT.encoder().enm("opCode", (Object)prepare.getResponseType());
                ArrayEncoder storesEncoder = ((StructEncoder)encoder).strings(STORES_FIELD);
                for (String storeName : prepare.getStores()) {
                    storesEncoder.value(storeName);
                }
                return ((StructEncoder)encoder).encode().array();
            }
            case RESOLVE_REQUEST: {
                EhcacheEntityResponse.ResolveRequest resolve = (EhcacheEntityResponse.ResolveRequest)response;
                return ((StructEncoder)((StructEncoder)RESOLVE_REQUEST_RESPONSE_STRUCT.encoder().enm("opCode", (Object)resolve.getResponseType())).int64("key", resolve.getKey())).struct(CHAIN_FIELD, resolve.getChain(), ChainCodec::encodeChain).encode().array();
            }
            case LOCK_SUCCESS: {
                EhcacheEntityResponse.LockSuccess lockSuccess = (EhcacheEntityResponse.LockSuccess)response;
                return ((StructEncoder)LOCK_RESPONSE_STRUCT.encoder().enm("opCode", (Object)lockSuccess.getResponseType())).struct(CHAIN_FIELD, lockSuccess.getChain(), ChainCodec::encodeChain).encode().array();
            }
            case LOCK_FAILURE: {
                EhcacheEntityResponse.LockFailure lockFailure = (EhcacheEntityResponse.LockFailure)response;
                return ((StructEncoder)LOCK_RESPONSE_STRUCT.encoder().enm("opCode", (Object)lockFailure.getResponseType())).encode().array();
            }
            case ITERATOR_BATCH: {
                EhcacheEntityResponse.IteratorBatch iteratorBatch = (EhcacheEntityResponse.IteratorBatch)response;
                return ((StructEncoder)((StructEncoder)((StructEncoder)ITERATOR_BATCH_STRUCT.encoder().enm("opCode", (Object)iteratorBatch.getResponseType())).string("id", iteratorBatch.getIdentity().toString())).structs("chains", iteratorBatch.getChains(), ChainCodec::encodeChainEntry).bool("last", iteratorBatch.isLast())).encode().array();
            }
        }
        throw new UnsupportedOperationException("The operation is not supported : " + String.valueOf((Object)response.getResponseType()));
    }

    public EhcacheEntityResponse decode(byte[] payload) {
        ByteBuffer buffer = ByteBuffer.wrap(payload);
        StructDecoder<Void> decoder = SUCCESS_RESPONSE_STRUCT.decoder(buffer);
        Enm opCodeEnm = decoder.enm("opCode");
        if (!opCodeEnm.isFound()) {
            throw new AssertionError((Object)"Got a response without an opCode");
        }
        if (!opCodeEnm.isValid()) {
            return null;
        }
        EhcacheResponseType opCode = (EhcacheResponseType)((Object)opCodeEnm.get());
        buffer.rewind();
        switch (opCode) {
            case SUCCESS: {
                return EhcacheEntityResponse.success();
            }
            case FAILURE: {
                decoder = FAILURE_RESPONSE_STRUCT.decoder(buffer);
                ClusterException exception = ExceptionCodec.decode(decoder.struct(EXCEPTION_FIELD));
                return EhcacheEntityResponse.failure(exception.withClientStackTrace());
            }
            case GET_RESPONSE: {
                decoder = GET_RESPONSE_STRUCT.decoder(buffer);
                return EhcacheEntityResponse.getResponse(ChainCodec.decodeChain(decoder.struct(CHAIN_FIELD)));
            }
            case HASH_INVALIDATION_DONE: {
                decoder = HASH_INVALIDATION_DONE_RESPONSE_STRUCT.decoder(buffer);
                long key = decoder.int64("key");
                return EhcacheEntityResponse.hashInvalidationDone(key);
            }
            case ALL_INVALIDATION_DONE: {
                return EhcacheEntityResponse.allInvalidationDone();
            }
            case SERVER_APPEND: {
                decoder = SERVER_APPEND_RESPONSE_STRUCT.decoder(buffer);
                ByteBuffer appended = decoder.byteBuffer(APPENDED_FIELD);
                StructDecoder<StructDecoder<Void>> chainDecoder = decoder.struct(CHAIN_FIELD);
                Chain chain = chainDecoder == null ? null : ChainCodec.decodeChain(chainDecoder);
                return EhcacheEntityResponse.serverAppend(appended, chain);
            }
            case CLIENT_INVALIDATE_HASH: {
                decoder = CLIENT_INVALIDATE_HASH_RESPONSE_STRUCT.decoder(buffer);
                long key = decoder.int64("key");
                int invalidationId = decoder.int32(INVALIDATION_ID_FIELD);
                return EhcacheEntityResponse.clientInvalidateHash(key, invalidationId);
            }
            case CLIENT_INVALIDATE_ALL: {
                decoder = CLIENT_INVALIDATE_ALL_RESPONSE_STRUCT.decoder(buffer);
                int invalidationId = decoder.int32(INVALIDATION_ID_FIELD);
                return EhcacheEntityResponse.clientInvalidateAll(invalidationId);
            }
            case SERVER_INVALIDATE_HASH: {
                decoder = SERVER_INVALIDATE_HASH_RESPONSE_STRUCT.decoder(buffer);
                long key = decoder.int64("key");
                StructDecoder<StructDecoder<Void>> chainDecoder = decoder.struct(CHAIN_FIELD);
                Chain evictedChain = chainDecoder == null ? null : ChainCodec.decodeChain(chainDecoder);
                return EhcacheEntityResponse.serverInvalidateHash(key, evictedChain);
            }
            case MAP_VALUE: {
                decoder = MAP_VALUE_RESPONSE_STRUCT.decoder(buffer);
                return EhcacheEntityResponse.mapValue(Util.unmarshall(decoder.byteBuffer(MAP_VALUE_FIELD), StateRepositoryOpCodec.WHITELIST_PREDICATE));
            }
            case PREPARE_FOR_DESTROY: {
                decoder = PREPARE_FOR_DESTROY_RESPONSE_STRUCT.decoder(buffer);
                ArrayDecoder<String, StructDecoder<Void>> storesDecoder = decoder.strings(STORES_FIELD);
                HashSet<String> stores = new HashSet<String>();
                for (int i = 0; i < storesDecoder.length(); ++i) {
                    stores.add(storesDecoder.value());
                }
                return EhcacheEntityResponse.prepareForDestroy(stores);
            }
            case RESOLVE_REQUEST: {
                decoder = RESOLVE_REQUEST_RESPONSE_STRUCT.decoder(buffer);
                long key = decoder.int64("key");
                Chain chain = ChainCodec.decodeChain(decoder.struct(CHAIN_FIELD));
                return EhcacheEntityResponse.resolveRequest(key, chain);
            }
            case LOCK_SUCCESS: {
                decoder = LOCK_RESPONSE_STRUCT.decoder(buffer);
                Chain chain = ChainCodec.decodeChain(decoder.struct(CHAIN_FIELD));
                return new EhcacheEntityResponse.LockSuccess(chain);
            }
            case LOCK_FAILURE: {
                return EhcacheEntityResponse.lockFailure();
            }
            case ITERATOR_BATCH: {
                decoder = ITERATOR_BATCH_STRUCT.decoder(buffer);
                UUID id = UUID.fromString(decoder.string("id"));
                StructArrayDecoder<StructDecoder<Void>> chainsDecoder = decoder.structs("chains");
                ArrayList<Map.Entry<Long, Chain>> chains = new ArrayList<Map.Entry<Long, Chain>>(chainsDecoder.length());
                while (chainsDecoder.hasNext()) {
                    chains.add(ChainCodec.decodeChainEntry(chainsDecoder.next()));
                }
                boolean last = decoder.bool("last");
                return EhcacheEntityResponse.iteratorBatchResponse(id, chains, last);
            }
        }
        throw new UnsupportedOperationException("The operation is not supported with opCode : " + String.valueOf((Object)opCode));
    }
}

