/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.config;

import org.ehcache.clustered.client.config.ClusteredResourceType;
import org.ehcache.clustered.client.config.SharedClusteredResourcePool;
import org.ehcache.clustered.common.PoolAllocation;
import org.ehcache.config.ResourcePool;
import org.ehcache.impl.config.AbstractResourcePool;

public class SharedClusteredResourcePoolImpl
extends AbstractResourcePool<SharedClusteredResourcePool, ClusteredResourceType<SharedClusteredResourcePool>>
implements SharedClusteredResourcePool {
    private final String sharedResourcePool;

    public SharedClusteredResourcePoolImpl(String sharedResourcePool) {
        super(ClusteredResourceType.Types.SHARED, true);
        if (sharedResourcePool == null) {
            throw new NullPointerException("sharedResourcePool identifier can not be null");
        }
        this.sharedResourcePool = sharedResourcePool;
    }

    @Override
    public String getSharedResourcePool() {
        return this.sharedResourcePool;
    }

    @Override
    public PoolAllocation getPoolAllocation() {
        return new PoolAllocation.Shared(this.getSharedResourcePool());
    }

    public void validateUpdate(ResourcePool newPool) {
        throw new UnsupportedOperationException("Updating CLUSTERED resource is not supported");
    }

    public String toString() {
        return "Pool {sharedResourcePool='" + this.sharedResourcePool + "' " + String.valueOf(this.getType()) + "}";
    }
}

