/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.config;

import java.time.Duration;
import java.util.function.LongSupplier;

public final class Timeouts {
    public static final Duration DEFAULT_OPERATION_TIMEOUT = Duration.ofSeconds(5L);
    public static final Duration DEFAULT_CONNECTION_TIMEOUT = Duration.ofSeconds(150L);
    public static final Duration INFINITE_TIMEOUT = Duration.ofNanos(Long.MAX_VALUE);
    public static final Timeouts DEFAULT = new Timeouts(DEFAULT_OPERATION_TIMEOUT, DEFAULT_OPERATION_TIMEOUT, DEFAULT_CONNECTION_TIMEOUT);
    private final Duration readOperationTimeout;
    private final Duration writeOperationTimeout;
    private final Duration connectionTimeout;

    public Timeouts(Duration readOperationTimeout, Duration writeOperationTimeout, Duration connectionTimeout) {
        this.readOperationTimeout = this.neverBeAfterInfinite(readOperationTimeout);
        this.writeOperationTimeout = this.neverBeAfterInfinite(writeOperationTimeout);
        this.connectionTimeout = this.neverBeAfterInfinite(connectionTimeout);
    }

    private Duration neverBeAfterInfinite(Duration duration) {
        return duration.compareTo(INFINITE_TIMEOUT) > 0 ? INFINITE_TIMEOUT : duration;
    }

    public Duration getReadOperationTimeout() {
        return this.readOperationTimeout;
    }

    public Duration getWriteOperationTimeout() {
        return this.writeOperationTimeout;
    }

    public Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Timeouts timeouts = (Timeouts)o;
        if (!this.readOperationTimeout.equals(timeouts.readOperationTimeout)) {
            return false;
        }
        if (!this.writeOperationTimeout.equals(timeouts.writeOperationTimeout)) {
            return false;
        }
        return this.connectionTimeout.equals(timeouts.connectionTimeout);
    }

    public int hashCode() {
        int result = this.readOperationTimeout.hashCode();
        result = 31 * result + this.writeOperationTimeout.hashCode();
        result = 31 * result + this.connectionTimeout.hashCode();
        return result;
    }

    public static LongSupplier nanosStartingFromNow(Duration timeout) {
        long end = System.nanoTime() + timeout.toNanos();
        return () -> end - System.nanoTime();
    }

    public String toString() {
        return "Timeouts{readOperation=" + String.valueOf(this.readOperationTimeout) + ", writeOperation=" + String.valueOf(this.writeOperationTimeout) + ", connection=" + String.valueOf(this.connectionTimeout) + "}";
    }
}

