/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util.io;

import com.tc.util.io.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.LinkedList;

public class TCFileUtils {
    public static boolean ensureWritableDir(File dir, EnsureWritableDirReporter reporter) {
        try {
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if (!dir.isDirectory()) {
                reporter.reportFailedCreate(dir, null);
                return false;
            }
            if (!dir.canWrite()) {
                reporter.reportReadOnly(dir, null);
                return false;
            }
        }
        catch (NullPointerException npe) {
            throw npe;
        }
        catch (Exception e) {
            reporter.reportFailedCreate(dir, e);
            return false;
        }
        return true;
    }

    public static void copyFile(File src, File dest) throws IOException {
        LinkedList<CopyTask> queue = new LinkedList<CopyTask>();
        queue.add(new CopyTask(src.getCanonicalFile(), dest.getCanonicalFile()));
        while (queue.size() > 0) {
            CopyTask item = (CopyTask)queue.remove(0);
            if (item.getSrc().isDirectory()) {
                File destDir = item.getDest();
                destDir.mkdirs();
                if (!destDir.isDirectory()) {
                    throw new IOException("Destination directory does not exist: " + String.valueOf(destDir));
                }
                String[] list = item.getSrc().list();
                if (list != null) {
                    for (String element : list) {
                        File _src = new File(item.getSrc(), element);
                        File _dest = new File(item.getDest(), element);
                        queue.add(new CopyTask(_src, _dest));
                    }
                    continue;
                }
                throw new RuntimeException("Error listing contents of [" + String.valueOf(item.getSrc()) + "]");
            }
            if (item.getSrc().isFile()) {
                try {
                    TCFileUtils.doCopy(item.getSrc(), item.getDest());
                }
                catch (IOException e) {
                    System.err.println("Error copying: [" + String.valueOf(item.getSrc()) + "] to [" + String.valueOf(item.getDest()) + "]");
                }
                continue;
            }
            throw new IOException(String.valueOf(item.getSrc()) + " is neither a file or a directory");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doCopy(File src, File dest) throws IOException {
        FileInputStream in = null;
        FileOutputStream out = null;
        byte[] buffer = new byte[8192];
        try {
            int count;
            in = new FileInputStream(src);
            out = new FileOutputStream(dest);
            while ((count = in.read(buffer)) >= 0) {
                out.write(buffer, 0, count);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly(in);
        IOUtils.closeQuietly(out);
    }

    public static interface EnsureWritableDirReporter {
        public void reportReadOnly(File var1, Exception var2);

        public void reportFailedCreate(File var1, Exception var2);
    }

    private static class CopyTask {
        private final File src;
        private final File dest;

        public CopyTask(File src, File dest) {
            this.src = src;
            this.dest = dest;
        }

        public File getSrc() {
            return this.src;
        }

        public File getDest() {
            return this.dest;
        }
    }
}

