/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReentrantLock;

public class UpdatableFixedHeap<E extends Ordered> {
    private final AtomicIntegerArray locks;
    private final int arrayLength;
    private final boolean rigid;
    private AtomicReferenceArray<UpdatableWrapper<E>> arr;
    private volatile int size = 0;
    private ReentrantLock lock = new ReentrantLock(true);

    public UpdatableFixedHeap(boolean rigid, E[] elements) {
        this.rigid = rigid;
        this.arr = new AtomicReferenceArray(elements.length + 1);
        this.locks = new AtomicIntegerArray(this.arr.length());
        this.arrayLength = this.arr.length();
        for (E e : elements) {
            this.add(e);
        }
        this.reheap();
    }

    private boolean orderLock(int index1, int index2) {
        if (this.rigid) {
            return this.orderLockRigid(index1, index2);
        }
        return this.orderLockTry(index1, index2);
    }

    private boolean orderLock(int index1, int index2, int index3) {
        if (this.rigid) {
            return this.orderLockRigid(index1, index2, index3);
        }
        return this.orderLockTry(index1, index2, index3);
    }

    private boolean orderLockTry(int index1, int index2) {
        if (index1 < this.arrayLength && !this.locks.compareAndSet(index1, 0, 1)) {
            return false;
        }
        if (index2 < this.arrayLength && !this.locks.compareAndSet(index2, 0, 1)) {
            if (index1 < this.arrayLength) {
                this.locks.compareAndSet(index1, 1, 0);
            }
            return false;
        }
        return true;
    }

    private boolean orderLockRigid(int index1, int index2) {
        if (index1 < this.arrayLength) {
            while (!this.locks.compareAndSet(index1, 0, 1)) {
            }
        }
        if (index2 < this.arrayLength) {
            while (!this.locks.compareAndSet(index2, 0, 1)) {
            }
        }
        return true;
    }

    private boolean orderLockTry(int index1, int index2, int index3) {
        if (index1 < this.arrayLength && !this.locks.compareAndSet(index1, 0, 1)) {
            return false;
        }
        if (index2 < this.arrayLength && !this.locks.compareAndSet(index2, 0, 1)) {
            if (index1 < this.arrayLength) {
                this.locks.compareAndSet(index1, 1, 0);
            }
            return false;
        }
        if (index3 < this.arrayLength && !this.locks.compareAndSet(index3, 0, 1)) {
            if (index1 < this.arrayLength) {
                this.locks.compareAndSet(index1, 1, 0);
            }
            if (index2 < this.arrayLength) {
                this.locks.compareAndSet(index2, 1, 0);
            }
            return false;
        }
        return true;
    }

    private boolean orderLockRigid(int index1, int index2, int index3) {
        if (index1 < this.arrayLength) {
            while (!this.locks.compareAndSet(index1, 0, 1)) {
            }
        }
        if (index2 < this.arrayLength) {
            while (!this.locks.compareAndSet(index2, 0, 1)) {
            }
        }
        if (index3 < this.arrayLength) {
            while (!this.locks.compareAndSet(index3, 0, 1)) {
            }
        }
        return true;
    }

    private void orderUnlock(int index1, int index2) {
        if (index1 < this.arrayLength) {
            this.locks.compareAndSet(index1, 1, 0);
        }
        if (index2 < this.arrayLength) {
            this.locks.compareAndSet(index2, 1, 0);
        }
    }

    private void orderUnlock(int index1, int index2, int index3) {
        if (index1 < this.arrayLength) {
            this.locks.compareAndSet(index1, 1, 0);
        }
        if (index2 < this.arrayLength) {
            this.locks.compareAndSet(index2, 1, 0);
        }
        if (index3 < this.arrayLength) {
            this.locks.compareAndSet(index3, 1, 0);
        }
    }

    public int getSize() {
        return this.size;
    }

    private UpdatableWrapper<E> add(E e) {
        UpdatableWrapper<E> wrapper = new UpdatableWrapper<E>(e, ++this.size);
        this.arr.set(this.size, wrapper);
        this.siftUp(this.size);
        return wrapper;
    }

    private void reheap() {
        for (int i = this.size; i > 0; --i) {
            this.siftUp(i);
        }
    }

    public void possiblyCloserToFront(UpdatableWrapper<E> w) {
        this.siftUp(w.index);
    }

    public void possiblyCloserToEnd(UpdatableWrapper<E> w) {
        this.siftDown(w.index);
    }

    private boolean siftDown(int index) {
        int next;
        int smallest = index;
        boolean workDone = false;
        while ((next = this.siftDownOne(index)) > 0) {
            index = next;
            workDone = true;
        }
        return workDone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int siftDownOne(int index) {
        int lock2;
        int lock1;
        int ret = -1;
        boolean workDone = false;
        int smallest = index;
        int left = index * 2;
        int right = index * 2 + 1;
        if (left <= this.size) {
            if (this.arr.get(left).getHeapOrderingAmount() < this.arr.get(smallest).getHeapOrderingAmount()) {
                smallest = left;
            } else if (right <= this.size && this.arr.get(right).getHeapOrderingAmount() < this.arr.get(smallest).getHeapOrderingAmount()) {
                smallest = right;
            }
        } else if (right <= this.size && this.arr.get(right).getHeapOrderingAmount() < this.arr.get(smallest).getHeapOrderingAmount()) {
            smallest = right;
        }
        if (smallest != index && this.orderLock(lock1 = index, lock2 = smallest)) {
            try {
                if (this.arr.get(index).getHeapOrderingAmount() > this.arr.get(smallest).getHeapOrderingAmount()) {
                    this.swap(index, smallest);
                    ret = smallest;
                }
            }
            finally {
                this.orderUnlock(lock1, lock2);
            }
        }
        return ret;
    }

    private void siftUp(int index) {
        int parent = index / 2;
        while (parent > 0 && this.siftUpOne(parent, index)) {
            index = parent;
            parent = index / 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean siftUpOne(int parent, int index) {
        int lock2;
        int lock1;
        if (parent > 0 && this.orderLock(lock1 = parent, lock2 = index)) {
            try {
                if (this.arr.get(parent).getHeapOrderingAmount() > this.arr.get(index).getHeapOrderingAmount()) {
                    this.swap(parent, index);
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                this.orderUnlock(lock1, lock2);
            }
        }
        return false;
    }

    private void swap(int parent, int index) {
        UpdatableWrapper<E> swap = this.arr.get(parent);
        this.arr.set(parent, this.arr.get(index));
        this.arr.set(index, swap);
        this.arr.get(parent).index(parent);
        this.arr.get(index).index(index);
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this._print(1, "", pw);
        pw.flush();
        return sw.toString();
    }

    void verify() {
        this._verify(1);
    }

    private void _verify(int i) {
        int n2;
        if (i > this.size) {
            return;
        }
        if (this.arr.get((int)i).index != i) {
            throw new AssertionError((Object)("At index: " + i));
        }
        int n1 = 2 * i;
        if (n1 <= this.size) {
            if (this.arr.get(i).getHeapOrderingAmount() > this.arr.get(n1).getHeapOrderingAmount()) {
                throw new AssertionError((Object)("At index: " + i));
            }
            this._verify(n1);
        }
        if ((n2 = n1 + 1) <= this.size) {
            if (this.arr.get(i).getHeapOrderingAmount() > this.arr.get(n2).getHeapOrderingAmount()) {
                throw new AssertionError((Object)("At index: " + i));
            }
            this._verify(n2);
        }
    }

    private void _print(int index, String indention, PrintWriter pw) {
        if (index > this.size) {
            return;
        }
        pw.println(indention + String.valueOf(this.arr.get(index)));
        int n1 = 2 * index;
        int n2 = n1 + 1;
        this._print(n1, indention + "  ", pw);
        this._print(n2, indention + "  ", pw);
    }

    public UpdatableWrapper top() {
        if (this.size == 0) {
            return null;
        }
        return this.arr.get(1);
    }

    public UpdatableWrapper<E> wrapperFor(int index) {
        return this.arr.get(index + 1);
    }

    public static interface Ordered {
        public int getHeapOrderingAmount();
    }

    public static class UpdatableWrapper<EE extends Ordered> {
        private final EE payload;
        private volatile int index;

        UpdatableWrapper(EE payload, int index) {
            this.payload = payload;
            this.index = index;
        }

        public int getHeapOrderingAmount() {
            return this.payload.getHeapOrderingAmount();
        }

        public EE getPayload() {
            return this.payload;
        }

        public int getIndex() {
            return this.index;
        }

        public UpdatableWrapper index(int index) {
            this.index = index;
            return this;
        }

        public String toString() {
            return "Wrapper{payload=" + String.valueOf(this.payload) + ", index=" + this.index + "}";
        }
    }
}

