/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util;

import com.tc.classloader.OverrideService;
import com.tc.classloader.OverrideServiceType;
import com.tc.util.Assert;
import com.tc.util.TCServiceLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedServiceLoader
implements TCServiceLoader.Provider {
    private static final Logger LOG = LoggerFactory.getLogger(ManagedServiceLoader.class);
    private static final String METAINFCONST = "META-INF/services/";

    public static <T> Collection<? extends T> loadServices(Class<T> serviceClass, ClassLoader loader) {
        return new ManagedServiceLoader().getImplementations(serviceClass, loader);
    }

    @Override
    public <T> Collection<? extends T> getImplementations(Class<T> serviceClass, ClassLoader loader) {
        return this.getImplementationsTypes(serviceClass, loader).stream().map(clazz -> {
            try {
                return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException("Unable to resolve service implementations for " + String.valueOf(serviceClass), e);
            }
        }).collect(Collectors.toList());
    }

    protected Collection<Class<?>> discoverImplementations(String interfaceName, ClassLoader loader) {
        try {
            HashSet<String> processed = new HashSet<String>();
            HashMap<String, ClassWithLocation> urls = new HashMap<String, ClassWithLocation>();
            HashMap<Object, String> overrides = new HashMap<Object, String>();
            Enumeration<URL> urlEnumeration = loader.getResources(METAINFCONST + interfaceName);
            StringBuilder sb = new StringBuilder();
            while (urlEnumeration.hasMoreElements()) {
                URL x = urlEnumeration.nextElement();
                String urlString = ManagedServiceLoader.parseURLString(x, interfaceName);
                if (!processed.add(urlString)) {
                    LOG.debug("already processed " + urlString);
                    continue;
                }
                LOG.debug("reading " + urlString + " for " + interfaceName);
                InputStream s = x.openStream();
                LineNumberReader reader = new LineNumberReader(new InputStreamReader(s, Charset.forName("UTF-8")));
                String split = reader.readLine();
                while (split != null) {
                    LOG.debug(reader.getLineNumber() + ":processing " + split);
                    String[] trim = split.trim().split("\\#");
                    split = reader.readLine();
                    for (int c = 0; c < trim.length; ++c) {
                        trim[c] = trim[c].trim();
                    }
                    if (trim.length == 0 || trim[0].isEmpty()) continue;
                    Class<?> type = this.loadClass(trim[0], urlString, loader);
                    if (type != null) {
                        ClassWithLocation previous;
                        Object value;
                        if (trim.length > 1) {
                            Object[] overridesClasses = ManagedServiceLoader.checkForOverride(trim[1]);
                            String[] stringArray = overridesClasses;
                            int n = stringArray.length;
                            for (int i = 0; i < n; ++i) {
                                String override = stringArray[i];
                                LOG.debug("overriding class " + override + " with " + trim[0]);
                                urls.remove(override);
                                overrides.put(override, trim[0]);
                            }
                        }
                        if (type.isAnnotationPresent(OverrideService.class)) {
                            for (OverrideService override : (OverrideService[])type.getAnnotationsByType(OverrideService.class)) {
                                LOG.debug("overriding class " + override.value() + " with annotation on " + trim[0]);
                                value = override.value();
                                String[] types = override.types();
                                if (value != null && ((String)value).length() > 0) {
                                    urls.remove(value);
                                    overrides.put(value, trim[0]);
                                }
                                for (String typeName : types) {
                                    urls.remove(typeName);
                                    overrides.put(typeName, trim[0]);
                                }
                            }
                        }
                        if (type.isAnnotationPresent(OverrideServiceType.class)) {
                            for (OverrideServiceType override : (OverrideServiceType[])type.getAnnotationsByType(OverrideServiceType.class)) {
                                LOG.debug("overriding class " + String.valueOf(override.value()) + " with annotation on " + trim[0]);
                                value = override.value();
                                if (value == null) continue;
                                urls.remove(((Class)value).getName());
                                overrides.put(((Class)value).getName(), trim[0]);
                            }
                        }
                        if (overrides.containsKey(trim[0]) || (previous = urls.putIfAbsent(trim[0], new ClassWithLocation(type, urlString))) == null) continue;
                        LOG.info("MULTIPLE instances of " + trim[0] + " found, ignoring:" + urlString + " keeping:" + previous.location + " using classloader:" + String.valueOf(type.getClassLoader()));
                        continue;
                    }
                    LOG.info(trim[0] + " is not loadable from " + urlString + " skipping");
                }
                sb.setLength(0);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("implementations:" + urls.toString());
                LOG.debug("overrides:" + overrides.toString());
            }
            return urls.values().stream().map(cwl -> cwl.impl).collect(Collectors.toList());
        }
        catch (IOException e) {
            LOG.warn("unable to load", (Throwable)e);
            return null;
        }
    }

    private static String parseURLString(URL src, String interfaceName) {
        String urlString = src.toExternalForm();
        if (urlString.startsWith("jar:")) {
            int resourcePart = urlString.indexOf("!/META-INF/services/" + interfaceName);
            urlString = urlString.substring(4, resourcePart);
        } else {
            int index = urlString.indexOf(METAINFCONST);
            urlString = urlString.substring(0, index);
        }
        return urlString;
    }

    private static String[] checkForOverride(String value) {
        int index = value.indexOf("overrides ");
        if (index >= 0) {
            String[] list = value.substring(index + 10).trim().split(",");
            for (int x = 0; x < list.length; ++x) {
                list[x] = list[x].trim();
            }
            return list;
        }
        return new String[0];
    }

    public <T> List<Class<? extends T>> getImplementationsTypes(final Class<T> interfaceClass, ClassLoader loader) {
        Assert.assertNotNull(loader);
        Collection<Class<?>> items = this.getImplementations(interfaceClass.getName(), loader);
        final Class[] list = items.toArray(new Class[items.size()]);
        return new AbstractList<Class<? extends T>>(){

            @Override
            public Class<? extends T> get(int index) {
                Class got = list[index];
                try {
                    return got.asSubclass(interfaceClass);
                }
                catch (ClassCastException cast) {
                    ClassLoader loader = interfaceClass.getClassLoader();
                    ClassLoader sub = got.getInterfaces()[0].getClassLoader();
                    LOG.warn("There has been a class cast exception.  This is usually an indication that a service has been improperly packaged with system dependencies included.  Offending class is " + interfaceClass.getName());
                    throw cast;
                }
            }

            @Override
            public int size() {
                return list.length;
            }
        };
    }

    private Collection<Class<?>> getImplementations(String interfaceName, ClassLoader loader) {
        Collection<Class<?>> urls;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Discovering " + interfaceName + " with parent classloader " + loader.getClass().getName());
        }
        if (null == (urls = this.discoverImplementations(interfaceName, loader)) || urls.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No implementations found for " + interfaceName);
            }
            return Collections.emptyList();
        }
        return urls;
    }

    protected Class<?> loadClass(String className, String location, ClassLoader loader) {
        try {
            URLClassLoader l2 = new URLClassLoader(new URL[]{new URL(location)}, loader);
            return Class.forName(className, true, l2);
        }
        catch (NoClassDefFoundError e) {
            LOG.warn("Loading implementation failed for " + className + ". Check entity classpath and packaging", (Throwable)e);
        }
        catch (ClassNotFoundException c) {
            LOG.warn("No implementations found for " + className, (Throwable)c);
        }
        catch (MalformedURLException m) {
            LOG.warn("No implementations found for " + className, (Throwable)m);
        }
        return null;
    }

    static {
        TCServiceLoader.setImplementation(new ManagedServiceLoader());
    }

    private static class ClassWithLocation {
        private final Class<?> impl;
        private final String location;

        public ClassWithLocation(Class<?> impl, String location) {
            this.impl = impl;
            this.location = location;
        }
    }
}

