/*
 * Decompiled with CFR 0.152.
 */
package com.tc.text;

import com.tc.text.PrettyPrintable;
import com.tc.text.PrettyPrinter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;

public class PrettyPrinterImpl
implements PrettyPrinter {
    private static final String INDENT = "--> ";
    private final StringBuffer prefix;
    private final PrintWriter out;
    private final IdentityHashMap<Object, String> visited;
    private final PrintPolicy defaultPolicy = new BasicPrintPolicy();
    private final Collection<PrintPolicy> policies;
    private boolean autoflush = true;

    public PrettyPrinterImpl(PrintWriter out) {
        this(INDENT, out, new IdentityHashMap<Object, String>());
    }

    private PrettyPrinterImpl(String prefix, PrintWriter out, IdentityHashMap<Object, String> visited) {
        this.prefix = new StringBuffer(prefix);
        this.out = out;
        this.visited = visited;
        this.policies = this.initPolicies();
    }

    public synchronized void autoflush(boolean b) {
        this.autoflush = b;
    }

    public synchronized boolean autoflush() {
        return this.autoflush;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean accountFor(Object o) {
        if (o == null) {
            return false;
        }
        IdentityHashMap<Object, String> identityHashMap = this.visited;
        synchronized (identityHashMap) {
            if (this.visited.containsKey(o)) {
                return true;
            }
            this.visited.put(o, "");
            return false;
        }
    }

    public PrettyPrinter print(Object o) {
        this.out.print(o);
        if (this.autoflush()) {
            this.out.flush();
        }
        return this;
    }

    @Override
    public PrettyPrinter println(Object o) {
        this.out.println(o);
        if (this.autoflush()) {
            this.out.flush();
        }
        return this;
    }

    public PrettyPrinter println() {
        this.out.println();
        if (this.autoflush()) {
            this.out.flush();
        }
        return this;
    }

    public PrettyPrinter indent() {
        return this.print(this.prefix);
    }

    public PrettyPrinter duplicateAndIndent() {
        PrettyPrinterImpl rv = this.duplicate();
        rv.indentPrefix();
        return rv;
    }

    private void indentPrefix() {
        if (this.prefix.indexOf("+") > -1) {
            this.prefix.replace(this.prefix.indexOf("+"), this.prefix.indexOf("+") + 1, "|");
        }
        this.prefix.insert(this.prefix.indexOf("-->"), "    +");
    }

    private PrettyPrinterImpl duplicate() {
        PrettyPrinterImpl prettyPrinterImpl = new PrettyPrinterImpl(this.prefix.toString(), this.out, this.visited);
        prettyPrinterImpl.autoflush(this.autoflush);
        return prettyPrinterImpl;
    }

    public PrettyPrinter visit(Object o) {
        if (this.accountFor(o)) {
            this.print("ALREADY VISITED: " + String.valueOf(o));
            return this;
        }
        return this.basicVisit(o);
    }

    private PrettyPrinter basicVisit(Object o) {
        PrintPolicy policy = this.findPolicyFor(o);
        return policy.visit(this, o);
    }

    private PrintPolicy findPolicyFor(Object o) {
        if (o == null) {
            return this.defaultPolicy;
        }
        for (PrintPolicy policy : this.policies) {
            if (!policy.accepts(o)) continue;
            return policy;
        }
        return this.defaultPolicy;
    }

    private Collection<PrintPolicy> initPolicies() {
        ArrayList<PrintPolicy> rv = new ArrayList<PrintPolicy>();
        rv.add(new PrettyPrintablePrintPolicy());
        rv.add(new ShallowMapPrintPolicy());
        rv.add(new ShallowCollectionPrintPolicy());
        rv.add(this.defaultPolicy);
        return rv;
    }

    @Override
    public void flush() {
        this.out.flush();
    }

    private static class BasicPrintPolicy
    implements PrintPolicy {
        private BasicPrintPolicy() {
        }

        @Override
        public PrettyPrinter visit(PrettyPrinter pp, Object o) {
            return pp.println(o);
        }

        @Override
        public boolean accepts(Object o) {
            return true;
        }
    }

    private static interface PrintPolicy {
        public PrettyPrinter visit(PrettyPrinter var1, Object var2);

        public boolean accepts(Object var1);
    }

    private static class PrettyPrintablePrintPolicy
    implements PrintPolicy {
        private PrettyPrintablePrintPolicy() {
        }

        @Override
        public PrettyPrinter visit(PrettyPrinter pp, Object o) {
            return ((PrettyPrintable)o).prettyPrint(pp);
        }

        @Override
        public boolean accepts(Object o) {
            return o != null && o instanceof PrettyPrintable;
        }
    }

    private static class ShallowMapPrintPolicy
    implements PrintPolicy {
        private ShallowMapPrintPolicy() {
        }

        @Override
        public PrettyPrinter visit(PrettyPrinter pp, Object o) {
            return pp.println(o.getClass().getName()).println(".size()=").println("" + ((Map)o).size());
        }

        @Override
        public boolean accepts(Object o) {
            return o != null && o instanceof Map;
        }
    }

    private static class ShallowCollectionPrintPolicy
    implements PrintPolicy {
        private ShallowCollectionPrintPolicy() {
        }

        @Override
        public PrettyPrinter visit(PrettyPrinter pp, Object o) {
            return pp.println(o.getClass().getName()).println(".size()=").println("" + ((Collection)o).size());
        }

        @Override
        public boolean accepts(Object o) {
            return o != null && o instanceof Collection;
        }
    }
}

