/*
 * Decompiled with CFR 0.152.
 */
package com.tc.runtime;

import com.tc.runtime.Jdk15MemoryUsage;
import com.tc.runtime.MemoryUsage;
import com.tc.runtime.TCMemoryManagerJdk15Basic;
import com.tc.util.runtime.Vm;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

class TCMemoryManagerJdk15PoolMonitor
extends TCMemoryManagerJdk15Basic {
    private static final String OLD_GEN_NAME = "OLD GEN";
    private static final String TENURED_GEN_NAME = "TENURED GEN";
    private static final String IBMJDK_TENURED_GEN_NAME = "Java heap";
    private static final String JROCKETJDK_OLD_GEN_NAME = "Old Space";
    private final boolean memoryPoolMonitoringSupported;
    private final MemoryPoolMXBean oldGenBean;
    private final GarbageCollectorMXBean oldGenCollectorBean;

    public TCMemoryManagerJdk15PoolMonitor() {
        boolean memoryPoolMonitoringSupportedTmp = false;
        MemoryPoolMXBean oldGenBeanTmp = null;
        GarbageCollectorMXBean oldGenCollectorBeanTmp = null;
        try {
            oldGenBeanTmp = this.getOldGenMemoryPoolBean();
            oldGenCollectorBeanTmp = this.getOldGenCollectorBean();
            memoryPoolMonitoringSupportedTmp = true;
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
        this.oldGenBean = oldGenBeanTmp;
        this.oldGenCollectorBean = oldGenCollectorBeanTmp;
        this.memoryPoolMonitoringSupported = memoryPoolMonitoringSupportedTmp;
    }

    private MemoryPoolMXBean getOldGenMemoryPoolBean() {
        List<MemoryPoolMXBean> pools = ManagementFactory.getMemoryPoolMXBeans();
        ArrayList<String> poolNames = new ArrayList<String>();
        for (MemoryPoolMXBean mpBean : pools) {
            String name = mpBean.getName();
            poolNames.add(name);
            if (mpBean.getType() != MemoryType.HEAP || !this.isOldGen(name)) continue;
            return mpBean;
        }
        throw new AssertionError((Object)("Old or Tenured Memory pool Not found : " + String.valueOf(poolNames)));
    }

    private GarbageCollectorMXBean getOldGenCollectorBean() {
        List<GarbageCollectorMXBean> gcs = ManagementFactory.getGarbageCollectorMXBeans();
        HashMap<String, List<String>> gcs2Pools = new HashMap<String, List<String>>();
        for (GarbageCollectorMXBean gc : gcs) {
            String[] managedPools = gc.getMemoryPoolNames();
            if (!gc.isValid() || managedPools == null) continue;
            for (String managedPool : managedPools) {
                if (!this.isOldGen(managedPool)) continue;
                return gc;
            }
            gcs2Pools.put(gc.getName(), Arrays.asList(managedPools));
        }
        throw new AssertionError((Object)("Old or Tenured Memory pool does not have a garbage collector : " + String.valueOf(gcs2Pools)));
    }

    private boolean isOldGen(String name) {
        if (Vm.isIBM()) {
            return name.indexOf(IBMJDK_TENURED_GEN_NAME) > -1;
        }
        if (Vm.isJRockit()) {
            return name.indexOf(JROCKETJDK_OLD_GEN_NAME) > -1;
        }
        return name.toUpperCase().indexOf(OLD_GEN_NAME) > -1 || name.toUpperCase().indexOf(TENURED_GEN_NAME) > -1;
    }

    @Override
    public boolean isMemoryPoolMonitoringSupported() {
        return this.memoryPoolMonitoringSupported;
    }

    @Override
    public MemoryUsage getOldGenUsage() {
        java.lang.management.MemoryUsage oldGenUsage = this.oldGenBean.getUsage();
        return new Jdk15MemoryUsage(oldGenUsage, this.oldGenBean.getName(), this.oldGenCollectorBean.getCollectionCount(), this.oldGenCollectorBean.getCollectionTime());
    }
}

