/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.msg;

import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.io.TCSerializable;
import com.tc.object.ClientInstanceID;
import com.tc.object.EntityID;
import java.io.IOException;

public class ClientEntityReferenceContext
implements TCSerializable<ClientEntityReferenceContext> {
    private EntityID entityID;
    private long entityVersion;
    private ClientInstanceID clientInstanceID;
    private byte[] extendedReconnectData;

    public ClientEntityReferenceContext() {
    }

    public ClientEntityReferenceContext(EntityID entityID, long entityVersion, ClientInstanceID clientInstanceID, byte[] extendedReconnectData) {
        this.entityID = entityID;
        this.entityVersion = entityVersion;
        this.clientInstanceID = clientInstanceID;
        this.extendedReconnectData = extendedReconnectData;
    }

    public EntityID getEntityID() {
        return this.entityID;
    }

    public ClientInstanceID getClientInstanceID() {
        return this.clientInstanceID;
    }

    public long getEntityVersion() {
        return this.entityVersion;
    }

    public byte[] getExtendedReconnectData() {
        return this.extendedReconnectData;
    }

    public boolean equals(Object o) {
        boolean isEqual;
        boolean bl = isEqual = this == o;
        if (!isEqual && o instanceof ClientEntityReferenceContext) {
            ClientEntityReferenceContext other = (ClientEntityReferenceContext)o;
            boolean bl2 = isEqual = this.entityID.equals(other.entityID) && this.entityVersion == other.entityVersion && this.clientInstanceID.equals(other.clientInstanceID);
            if (this.extendedReconnectData.length == other.extendedReconnectData.length) {
                for (int i = 0; isEqual && i < this.extendedReconnectData.length; ++i) {
                    isEqual = this.extendedReconnectData[i] == other.extendedReconnectData[i];
                }
            } else {
                isEqual = false;
            }
        }
        return isEqual;
    }

    public int hashCode() {
        return 13 * this.entityID.hashCode() ^ 7 * (int)this.entityVersion ^ 3 * this.clientInstanceID.hashCode();
    }

    @Override
    public void serializeTo(TCByteBufferOutput output) {
        this.entityID.serializeTo(output);
        output.writeLong(this.entityVersion);
        this.clientInstanceID.serializeTo(output);
        output.writeInt(this.extendedReconnectData.length);
        output.write(this.extendedReconnectData);
    }

    @Override
    public ClientEntityReferenceContext deserializeFrom(TCByteBufferInput input) throws IOException {
        this.entityID = EntityID.readFrom(input);
        this.entityVersion = input.readLong();
        this.clientInstanceID = ClientInstanceID.readFrom(input);
        int extendedDataLength = input.readInt();
        this.extendedReconnectData = new byte[extendedDataLength];
        input.readFully(this.extendedReconnectData);
        return this;
    }

    public String toString() {
        return "ClientEntityReferenceContext [entityID=" + String.valueOf(this.entityID) + ", entityVersion=" + this.entityVersion + ", clientInstanceID=" + String.valueOf(this.clientInstanceID) + ", extendedData size=" + this.extendedReconnectData.length + "]";
    }
}

