/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.tcm;

import com.tc.bytes.TCReferenceSupport;
import com.tc.net.core.TCConnection;
import com.tc.net.core.TCConnectionManager;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.NullMessageMonitor;
import com.tc.net.protocol.tcm.TCAction;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.properties.TCProperties;
import com.tc.text.StringFormatter;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.slf4j.Logger;

public class MessageMonitorImpl
implements MessageMonitor {
    private final Map<TCMessageType, MessageCounter> counters = new TreeMap<TCMessageType, MessageCounter>(new TCMessageTypeComparator());
    private final TCConnectionManager connections;
    private final StringFormatter formatter = new StringFormatter();
    private final ScheduledExecutorService timer = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread t = new Thread(grp, r, "MessageMonitor logger");
        t.setDaemon(true);
        return t;
    });
    private final ScheduledFuture<?> currentTask;
    private int maxTypeWidth = 0;

    public static MessageMonitor createMonitor(TCProperties tcProps, Logger logger, ThreadGroup group, TCConnectionManager mgr) {
        MessageMonitor mm = tcProps.getBoolean("tcm.monitor.enabled", false) ? new MessageMonitorImpl(group, logger, mgr, tcProps.getInt("tcm.monitor.delay")) : new NullMessageMonitor();
        return mm;
    }

    public MessageMonitorImpl(ThreadGroup grp, Logger logger, TCConnectionManager mgr, int delay) {
        this.connections = mgr;
        this.currentTask = this.startLogging(logger, delay);
    }

    private ScheduledFuture<?> startLogging(Logger logger, int intervalSeconds) {
        if (intervalSeconds < 1) {
            throw new IllegalArgumentException("invalid interval: " + intervalSeconds);
        }
        TCReferenceSupport.startMonitoringReferences();
        return this.timer.scheduleAtFixedRate(() -> {
            TCConnection[] list;
            logger.info(this.toString());
            int count = TCReferenceSupport.checkReferences();
            if (count > 0) {
                logger.info("found {} memory references that were not closed", (Object)count);
            }
            for (TCConnection c : list = this.connections.getAllConnections()) {
                Map<String, ?> state = c.getState();
                long sent = (Long)state.get("messageBatch");
                long write = (Long)state.get("messageWritten");
                long recv = (Long)state.get("messageRead");
                logger.info("\n" + this.formatter.rightPad(60, String.valueOf(state.get("localAddress")) + " -> " + String.valueOf(state.get("remoteAddress"))) + this.formatter.leftPad(20, "batch:" + sent) + this.formatter.leftPad(20, "write:" + write) + this.formatter.leftPad(20, "read:" + recv));
            }
        }, 0L, intervalSeconds, TimeUnit.SECONDS);
    }

    @Override
    public void shutdown() {
        this.currentTask.cancel(true);
        this.timer.shutdownNow();
        this.timer.shutdown();
    }

    @Override
    public void newIncomingMessage(TCAction message) {
        this.getOrCreateMessageCounter(message.getMessageType()).newIncomingMessage(message);
    }

    @Override
    public void newOutgoingMessage(TCAction message) {
        this.getOrCreateMessageCounter(message.getMessageType()).newOutgoingMessage(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MessageCounter getOrCreateMessageCounter(TCMessageType type) {
        Map<TCMessageType, MessageCounter> map = this.counters;
        synchronized (map) {
            MessageCounter rv = this.counters.get((Object)type);
            if (rv == null) {
                this.maxTypeWidth = Math.max(this.maxTypeWidth, type.getTypeName().length());
                rv = new MessageCounter(this.formatter, type.getTypeName());
                this.counters.put(type, rv);
            }
            return rv;
        }
    }

    public Map<TCMessageType, MessageCounter> getCounters() {
        return this.counters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuffer rv = new StringBuffer(nl);
        Map<TCMessageType, MessageCounter> map = this.counters;
        synchronized (map) {
            for (MessageCounter counter : this.counters.values()) {
                rv.append(counter.toString(this.maxTypeWidth)).append(nl);
            }
        }
        return rv.toString();
    }

    private static class TCMessageTypeComparator
    implements Comparator<TCMessageType>,
    Serializable {
        private TCMessageTypeComparator() {
        }

        @Override
        public int compare(TCMessageType t1, TCMessageType t2) {
            return t1.getTypeName().compareTo(t2.getTypeName());
        }
    }

    public static class MessageCounter {
        private final LongAdder incomingCount = new LongAdder();
        private final LongAdder incomingData = new LongAdder();
        private final LongAdder outgoingCount = new LongAdder();
        private final LongAdder outgoingData = new LongAdder();
        private final StringFormatter formatter;
        private final String name;

        private MessageCounter(StringFormatter formatter, String name) {
            this.formatter = formatter;
            this.name = name;
        }

        private void newIncomingMessage(TCAction message) {
            this.incomingCount.increment();
            this.incomingData.add(message.getMessageLength());
        }

        private void newOutgoingMessage(TCAction message) {
            this.outgoingCount.increment();
            this.outgoingData.add(message.getMessageLength());
        }

        public String toString(int nameWidth) {
            return this.formatter.rightPad(nameWidth, this.name) + " | IN: " + this.formatter.leftPad(15, this.incomingCount) + ", " + this.formatter.leftPad(30, this.incomingData) + " bytes | OUT: " + this.formatter.leftPad(15, this.outgoingCount) + ", " + this.formatter.leftPad(30, this.outgoingData) + " bytes";
        }

        public long getIncomingCount() {
            return this.incomingCount.sum();
        }

        public long getIncomingData() {
            return this.incomingData.sum();
        }

        public long getOutgoingCount() {
            return this.outgoingCount.sum();
        }

        public long getOutgoingData() {
            return this.outgoingData.sum();
        }

        public String getName() {
            return this.name;
        }
    }
}

