/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol;

import com.tc.bytes.TCByteBuffer;
import com.tc.bytes.TCReference;
import com.tc.net.core.TCConnection;
import com.tc.net.protocol.AbstractTCNetworkHeader;
import com.tc.net.protocol.TCNetworkHeader;
import com.tc.net.protocol.TCNetworkMessage;
import com.tc.net.protocol.TCProtocolAdaptor;
import com.tc.net.protocol.TCProtocolException;
import com.tc.util.Assert;
import org.slf4j.Logger;

public abstract class AbstractTCProtocolAdaptor
implements TCProtocolAdaptor {
    protected static final int MODE_HEADER = 1;
    protected static final int MODE_DATA = 2;
    private final Logger logger;
    private AbstractTCNetworkHeader header;
    private int dataBytesNeeded;
    private int mode;

    public AbstractTCProtocolAdaptor(Logger logger) {
        this.logger = logger;
        this.init();
    }

    @Override
    public int getExpectedBytes() {
        if (this.mode == 1) {
            return this.header.getDataBuffer().limit();
        }
        return this.dataBytesNeeded;
    }

    protected abstract AbstractTCNetworkHeader getNewProtocolHeader();

    protected abstract TCNetworkMessage createMessage(TCConnection var1, TCNetworkHeader var2, TCReference var3) throws TCProtocolException;

    protected abstract int computeDataLength(TCNetworkHeader var1);

    protected final void init() {
        this.mode = 1;
        this.header = this.getNewProtocolHeader();
    }

    protected final TCNetworkMessage processIncomingData(TCConnection source, TCReference data) throws TCProtocolException {
        if (this.mode == 1) {
            return this.processHeaderData(source, data);
        }
        Assert.eval(this.mode == 2);
        return this.processPayloadData(source, data);
    }

    protected final Logger getLogger() {
        return this.logger;
    }

    private TCNetworkMessage processHeaderData(TCConnection source, TCReference data) throws TCProtocolException {
        int headerLength = this.header.getHeaderByteLength();
        int bufferLength = this.header.getDataBuffer().limit();
        Assert.assertEquals(data.available(), (long)bufferLength);
        TCByteBuffer headerBuf = this.header.getDataBuffer();
        for (TCByteBuffer b : data) {
            headerBuf.put(b);
        }
        if (!this.header.isHeaderLengthAvail()) {
            return null;
        }
        if (headerLength == -1) {
            return null;
        }
        if (headerLength < this.header.minLength || headerLength > this.header.maxLength || headerLength < bufferLength) {
            throw new TCProtocolException("Invalid Header Length: " + headerLength + ", min: " + this.header.minLength + ", max: " + this.header.maxLength + ", bufLen: " + bufferLength);
        }
        if (bufferLength != headerLength) {
            this.header.getDataBuffer().limit(headerLength);
            return null;
        }
        Assert.eval(bufferLength == headerLength);
        if (this.header.getDataBuffer().position() == headerLength) {
            this.header.validate();
            this.mode = 2;
            this.dataBytesNeeded = this.computeDataLength(this.header);
            if (this.dataBytesNeeded < 0) {
                throw new TCProtocolException("Negative data size detected: " + this.dataBytesNeeded);
            }
            if (0 == this.dataBytesNeeded) {
                return this.createMessage(source, this.header, null);
            }
            if ((long)this.dataBytesNeeded < data.available()) {
                data.limit(this.dataBytesNeeded);
                return this.processPayloadData(source, data);
            }
            return null;
        }
        return null;
    }

    private TCNetworkMessage processPayloadData(TCConnection source, TCReference data) throws TCProtocolException {
        TCNetworkMessage msg = this.createMessage(source, this.header, data.duplicate());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Message complete on connection " + String.valueOf(source) + ": " + msg.toString());
        }
        return msg;
    }
}

