/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.state;

import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.io.TCSerializable;
import com.tc.net.NodeID;
import com.tc.net.groups.NodeIDSerializer;
import com.tc.util.Assert;
import java.io.IOException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Enrollment
implements TCSerializable<Enrollment> {
    private static final Logger logger = LoggerFactory.getLogger(Enrollment.class);
    private NodeID nodeID;
    private long[] weights;
    private boolean isNew;

    public Enrollment() {
    }

    public Enrollment(NodeID nodeID, boolean isNew, long[] weights) {
        this.nodeID = nodeID;
        this.isNew = isNew;
        Assert.assertNotNull(weights);
        this.weights = weights;
    }

    @Override
    public void serializeTo(TCByteBufferOutput out) {
        NodeIDSerializer nodeIDSerializer = new NodeIDSerializer(this.nodeID);
        nodeIDSerializer.serializeTo(out);
        out.writeBoolean(this.isNew);
        out.writeInt(this.weights.length);
        for (long weight : this.weights) {
            out.writeLong(weight);
        }
    }

    @Override
    public Enrollment deserializeFrom(TCByteBufferInput in) throws IOException {
        NodeIDSerializer nodeIDSerializer = new NodeIDSerializer();
        nodeIDSerializer = nodeIDSerializer.deserializeFrom(in);
        this.nodeID = nodeIDSerializer.getNodeID();
        this.isNew = in.readBoolean();
        this.weights = new long[in.readInt()];
        for (int i = 0; i < this.weights.length; ++i) {
            this.weights[i] = in.readLong();
        }
        return this;
    }

    public NodeID getNodeID() {
        return this.nodeID;
    }

    public boolean isANewCandidate() {
        return this.isNew;
    }

    public boolean wins(Enrollment other) {
        if (this.isNew != other.isNew) {
            return !this.isNew;
        }
        int myLength = this.weights.length;
        int otherLength = other.weights.length;
        if (myLength > otherLength) {
            return true;
        }
        if (myLength < otherLength) {
            return false;
        }
        for (int i = 0; i < myLength; ++i) {
            if (this.weights[i] > other.weights[i]) {
                return true;
            }
            if (this.weights[i] >= other.weights[i]) continue;
            return false;
        }
        logger.warn("Two Enrollments with same weights : " + String.valueOf(this) + " == " + String.valueOf(other));
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isNew ? 1231 : 1237);
        result = 31 * result + (this.nodeID == null ? 0 : this.nodeID.hashCode());
        result = 31 * result + Arrays.hashCode(this.weights);
        return result;
    }

    public boolean equals(Object o) {
        if (o instanceof Enrollment) {
            Enrollment oe = (Enrollment)o;
            return this.nodeID.equals(oe.nodeID) && Arrays.equals(this.weights, oe.weights) && this.isNew == oe.isNew;
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Enrollment [ ");
        sb.append(this.nodeID).append(", isNew = ").append(this.isNew);
        sb.append(", weights = ");
        int length = this.weights.length;
        for (int i = 0; i < length; ++i) {
            sb.append(this.weights[i]);
            if (i >= length - 1) continue;
            sb.append(",");
        }
        sb.append(" ]");
        return sb.toString();
    }

    public long[] getWeights() {
        return this.weights;
    }
}

