/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.msg;

import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.net.ServerID;
import com.tc.net.groups.AbstractGroupMessage;
import com.tc.net.groups.NodeIDSerializer;
import java.io.IOException;

public class ActiveJoinMessage
extends AbstractGroupMessage {
    public static final int ACTIVE_JOIN = 1;
    public static final int ACTIVE_LEFT = 2;
    public static final int ACTIVE_REQUEST_JOIN = 3;
    private ServerID serverID;

    public ActiveJoinMessage() {
        super(-1);
    }

    public ActiveJoinMessage(int type) {
        this(type, ServerID.NULL_ID);
    }

    public ActiveJoinMessage(int type, ServerID serverID) {
        super(type);
        this.serverID = serverID;
    }

    @Override
    protected void basicDeserializeFrom(TCByteBufferInput in) throws IOException {
        NodeIDSerializer nodeIDSerializer = new NodeIDSerializer();
        nodeIDSerializer.deserializeFrom(in);
        this.serverID = (ServerID)nodeIDSerializer.getNodeID();
    }

    @Override
    protected void basicSerializeTo(TCByteBufferOutput out) {
        NodeIDSerializer nodeIDSerializer = new NodeIDSerializer(this.serverID);
        nodeIDSerializer.serializeTo(out);
    }

    public ServerID getServerID() {
        return this.serverID;
    }

    public String toString() {
        return "ActiveJoinMessage:  -> " + String.valueOf(this.serverID);
    }

    public static AbstractGroupMessage createActiveJoinMessage(ServerID serverID) {
        return new ActiveJoinMessage(1, serverID);
    }

    public static AbstractGroupMessage createActiveLeftMessage() {
        return new ActiveJoinMessage(2);
    }

    public static AbstractGroupMessage createActiveRequestJoinMessage(ServerID serverID) {
        return new ActiveJoinMessage(3, serverID);
    }
}

