/*
 * Decompiled with CFR 0.152.
 */
package com.tc.async.impl;

import com.tc.async.api.AbstractEventHandler;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class TestEventHandler<EC>
extends AbstractEventHandler<EC> {
    private final List<EC> contexts = new LinkedList<EC>();

    @Override
    public synchronized void handleEvent(EC context) {
        System.out.println("Received " + String.valueOf(context));
        this.contexts.add(context);
        this.notifyAll();
    }

    public synchronized void waitForEventContextCount(int count, long timeout, TimeUnit unit) throws InterruptedException {
        if (count < 0) {
            throw new AssertionError((Object)("Count can not be less than 0. count=" + count));
        }
        long timeoutNanos = unit.toNanos(timeout);
        long start = System.nanoTime();
        while (this.contexts.size() < count && System.nanoTime() - start < timeoutNanos) {
            this.wait(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
        }
    }

    public synchronized List<EC> getContexts() {
        return new ArrayList<EC>(this.contexts);
    }
}

