/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.lease;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.terracotta.lease.TimeSource;

public class TestTimeSource
implements TimeSource {
    private volatile long time = 1L;
    private final Semaphore sleeping = new Semaphore(0);

    public boolean waitUntilSleeping(long timeout, TimeUnit unit) throws InterruptedException {
        return this.sleeping.tryAcquire(1, timeout, unit);
    }

    public void tickNanos(long increment) {
        this.time += increment;
    }

    public void tickMillis(long increment) {
        this.tickNanos(TimeUnit.NANOSECONDS.convert(increment, TimeUnit.MILLISECONDS));
    }

    @Override
    public long nanoTime() {
        return this.time;
    }

    @Override
    public void sleep(long milliseconds) throws InterruptedException {
        long now = this.time;
        long end = now + TimeUnit.NANOSECONDS.convert(milliseconds, TimeUnit.MILLISECONDS);
        this.sleeping.release();
        while (this.time - end < 0L) {
            Thread.sleep(10L);
        }
    }
}

