/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.model;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.terracotta.dynamic_config.api.model.Setting;

public class OptionalConfig<T> {
    private final Setting setting;
    private final T value;

    private OptionalConfig(Setting setting, T value) {
        this.setting = Objects.requireNonNull(setting);
        this.value = value;
    }

    public T get() throws NoSuchElementException {
        if (this.value == null) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public boolean isConfigured() {
        return this.value != null;
    }

    public void ifConfigured(Consumer<? super T> consumer) {
        if (this.value != null) {
            consumer.accept(this.value);
        }
    }

    public T orElse(T other) {
        return this.value != null ? this.value : other;
    }

    public T orDefault() {
        return (T)this.orElseGet(this.setting::getDefaultValue);
    }

    public T orElseGet(Supplier<? extends T> other) {
        return this.value != null ? this.value : other.get();
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.value != null) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public boolean is(T other) {
        return Objects.equals(this.value, other);
    }

    public Optional<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        return this.value == null ? Optional.empty() : (predicate.test(this.value) ? Optional.of(this.value) : Optional.empty());
    }

    public <U> Optional<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        return this.value == null ? Optional.empty() : Optional.ofNullable(mapper.apply(this.value));
    }

    public <U> Optional<U> flatMap(Function<? super T, Optional<U>> mapper) {
        Objects.requireNonNull(mapper);
        return this.value == null ? Optional.empty() : Objects.requireNonNull(mapper.apply(this.value));
    }

    public Optional<T> asOptional() {
        return Optional.ofNullable(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OptionalConfig)) {
            return false;
        }
        OptionalConfig other = (OptionalConfig)obj;
        return Objects.equals(this.value, other.value) && Objects.equals((Object)this.setting, (Object)other.setting);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.setting});
    }

    public String toString() {
        return this.setting + "=" + Setting.toProperty(this.value).orElse("<unset>");
    }

    public static <T> OptionalConfig<T> of(Setting setting, T value) {
        return new OptionalConfig<T>(setting, value);
    }
}

