/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util.runtime;

import java.util.Locale;
import java.util.Properties;

public final class VmVersion {
    private final boolean isIBM;
    private final boolean isJRockit;

    public VmVersion(Properties props) {
        this(VmVersion.isJRockit(props), VmVersion.isIBM(props));
    }

    private VmVersion(boolean isJRockit, boolean isIBM) {
        this.isIBM = isIBM;
        this.isJRockit = isJRockit;
    }

    public boolean isIBM() {
        return this.isIBM;
    }

    public boolean isJRockit() {
        return this.isJRockit;
    }

    private static boolean isIBM(Properties props) {
        String name = props.getProperty("java.vm.name", "").toLowerCase(Locale.ENGLISH);
        return name.contains("ibm") || name.contains("openj9");
    }

    private static boolean isJRockit(Properties props) {
        return props.getProperty("jrockit.version") != null || props.getProperty("java.vm.name", "").toLowerCase(Locale.ENGLISH).indexOf("jrockit") >= 0;
    }
}

