/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class SinglyLinkedList<E extends LinkedNode<E>>
implements Iterable<E> {
    private E head = null;
    private E tail = null;

    public boolean isEmpty() {
        return this.head == null;
    }

    public void addFirst(E first) {
        first.setNext(this.head);
        this.head = first;
        if (this.tail == null) {
            this.tail = first;
        }
    }

    public E removeFirst() {
        if (this.head == null) {
            throw new NoSuchElementException();
        }
        E first = this.head;
        this.head = first.setNext(null);
        if (this.tail == first) {
            this.tail = null;
        }
        return first;
    }

    public E getFirst() {
        if (this.head == null) {
            throw new NoSuchElementException();
        }
        return this.head;
    }

    public void addLast(E last) {
        if (this.tail == null) {
            this.addFirst(last);
            return;
        }
        this.tail.setNext(last);
        this.tail = last;
    }

    public E removeLast() {
        Object next;
        if (this.tail == null) {
            throw new NoSuchElementException();
        }
        if (this.head == this.tail) {
            return this.removeFirst();
        }
        Object cur = this.head;
        while ((next = cur.getNext()) != this.tail) {
            cur = next;
        }
        cur.setNext(null);
        this.tail = cur;
        return (E)next;
    }

    public E getLast() {
        if (this.tail == null) {
            throw new NoSuchElementException();
        }
        return this.tail;
    }

    public E remove(E obj) {
        LinkedNode current = null;
        for (Object next = this.head; next != null; next = next.getNext()) {
            LinkedNode prev = current;
            current = (LinkedNode)next;
            if (current != obj && !obj.equals(current)) continue;
            if (prev == null) {
                this.head = current.setNext(null);
            } else {
                prev.setNext(current.setNext(null));
            }
            if (next == null) {
                this.tail = prev;
            }
            return (E)current;
        }
        return null;
    }

    @Override
    public SinglyLinkedListIterator<E> iterator() {
        return new ListIterator();
    }

    public static interface LinkedNode<L extends LinkedNode<L>> {
        public L getNext();

        public L setNext(L var1);
    }

    protected class ListIterator
    implements SinglyLinkedListIterator<E> {
        E prev = null;
        E current = null;
        E next;

        protected ListIterator() {
            this.next = SinglyLinkedList.this.head;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public E next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.prev = this.current;
            this.current = this.next;
            this.next = this.next.getNext();
            return this.current;
        }

        @Override
        public void addNext(E e) {
            if (this.current == null || this.current == this.prev) {
                throw new IllegalStateException();
            }
            e.setNext(this.next);
            this.current.setNext(e);
            if (this.next == null) {
                SinglyLinkedList.this.tail = e;
            }
            this.next = e;
        }

        @Override
        public void addPrevious(E e) {
            if (this.current == null || this.current == this.prev) {
                throw new IllegalStateException();
            }
            e.setNext(this.current);
            if (this.prev == null) {
                SinglyLinkedList.this.head = e;
            } else {
                this.prev.setNext(e);
            }
            this.prev = e;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            if (this.prev == null) {
                SinglyLinkedList.this.head = this.current.setNext(null);
            } else {
                this.prev.setNext(this.current.setNext(null));
            }
            if (this.next == null) {
                SinglyLinkedList.this.tail = this.prev;
            }
            this.current = this.prev;
        }
    }

    public static interface SinglyLinkedListIterator<I extends LinkedNode<I>>
    extends Iterator<I> {
        @Override
        public boolean hasNext();

        @Override
        public I next();

        @Override
        public void remove();

        public void addNext(I var1);

        public void addPrevious(I var1);
    }
}

