/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.entity.InvocationCallback;

public interface SafeInvocationCallback<R>
extends InvocationCallback<R> {
    public static <R> SafeInvocationCallback<R> safe(InvocationCallback<R> callback) {
        if (callback instanceof SafeInvocationCallback) {
            return (SafeInvocationCallback)callback;
        }
        return new Guard<R>(callback);
    }

    public static class Guard<R>
    implements SafeInvocationCallback<R> {
        private static final Logger LOGGER = LoggerFactory.getLogger(SafeInvocationCallback.class);
        private final InvocationCallback<R> untrustedCallback;

        private Guard(InvocationCallback<R> untrustedCallback) {
            this.untrustedCallback = untrustedCallback;
        }

        @Override
        public void sent() {
            try {
                this.untrustedCallback.sent();
            }
            catch (Exception t) {
                LOGGER.warn("User-provided callback [" + this.untrustedCallback + "] threw exception", (Throwable)t);
            }
            catch (Throwable t) {
                LOGGER.warn("User-provided callback [" + this.untrustedCallback + "] threw throwable", t);
            }
        }

        @Override
        public void received() {
            try {
                this.untrustedCallback.received();
            }
            catch (Exception t) {
                LOGGER.warn("User-provided callback [" + this.untrustedCallback + "] threw exception", (Throwable)t);
            }
            catch (Throwable t) {
                LOGGER.warn("User-provided callback [" + this.untrustedCallback + "] threw throwable", t);
            }
        }

        @Override
        public void result(R response) {
            try {
                this.untrustedCallback.result(response);
            }
            catch (Exception t) {
                LOGGER.warn("User-provided callback [" + this.untrustedCallback + "] threw exception", (Throwable)t);
            }
            catch (Throwable t) {
                LOGGER.warn("User-provided callback [" + this.untrustedCallback + "] threw throwable", t);
            }
        }

        @Override
        public void failure(Throwable failure) {
            try {
                this.untrustedCallback.failure(failure);
            }
            catch (Exception t) {
                LOGGER.warn("User-provided callback [" + this.untrustedCallback + "] threw exception", (Throwable)t);
            }
            catch (Throwable t) {
                LOGGER.warn("User-provided callback [" + this.untrustedCallback + "] threw throwable", t);
            }
        }

        @Override
        public void complete() {
            try {
                this.untrustedCallback.complete();
            }
            catch (Exception t) {
                LOGGER.warn("User-provided callback [" + this.untrustedCallback + "] threw exception", (Throwable)t);
            }
            catch (Throwable t) {
                LOGGER.warn("User-provided callback [" + this.untrustedCallback + "] threw throwable", t);
            }
        }

        @Override
        public void retired() {
            try {
                this.untrustedCallback.retired();
            }
            catch (Exception t) {
                LOGGER.warn("User-provided callback [" + this.untrustedCallback + "] threw exception", (Throwable)t);
            }
            catch (Throwable t) {
                LOGGER.warn("User-provided callback [" + this.untrustedCallback + "] threw throwable", t);
            }
        }
    }
}

