/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.core;

import com.tc.bytes.TCByteBuffer;
import com.tc.bytes.TCByteBufferFactory;
import com.tc.bytes.TCDirectByteBufferCache;
import com.tc.bytes.TCReference;
import com.tc.bytes.TCReferenceSupport;
import com.tc.net.core.SocketEndpoint;
import com.tc.util.Assert;
import java.io.EOFException;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCSocketEndpointReader
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(TCSocketEndpointReader.class);
    private final Function<Integer, TCByteBuffer> allocator;
    private final Consumer<TCByteBuffer> returns;
    private TCByteBuffer readBuffer;
    private TCReference current;
    private int readTo = 0;

    public TCSocketEndpointReader() {
        this.allocator = s -> TCByteBufferFactory.getInstance(s);
        this.returns = b -> {};
    }

    public TCSocketEndpointReader(TCDirectByteBufferCache cache) {
        this.allocator = s -> cache.poll();
        this.returns = cache::offer;
    }

    TCSocketEndpointReader(Function<Integer, TCByteBuffer> allocator, Consumer<TCByteBuffer> returns) {
        this.allocator = allocator;
        this.returns = returns;
    }

    public TCReference readFromSocket(SocketEndpoint endpoint, int len) throws IOException {
        TCByteBuffer next;
        LOGGER.debug("{} requesting:{} {} {}", new Object[]{endpoint, len, this.readBuffer, this.readTo});
        if (this.readBuffer == null) {
            TCByteBuffer newBuf = this.allocator.apply(len);
            this.replaceCurrent(newBuf, this.createCompleteReference(newBuf), 0);
        }
        if (this.readBuffer.position() - this.readTo >= len) {
            this.current.stream().findFirst().get().position(this.readTo).limit(this.readTo + len);
            TCReference ref = this.current.duplicate();
            this.readTo += len;
            LOGGER.debug("returning from cached bytes:{} {}", (Object)ref.available(), (Object)this.readBuffer);
            return ref;
        }
        LinkedList<TCByteBuffer> newBufs = new LinkedList<TCByteBuffer>();
        for (int capacity = this.readBuffer.limit() - this.readTo; capacity < len; capacity += next.limit()) {
            next = this.allocator.apply(len - capacity);
            newBufs.add(next);
        }
        newBufs.addFirst(this.readBuffer);
        long received = this.readBuffer.position() - this.readTo;
        int rotations = 0;
        while (received < (long)len) {
            try {
                LOGGER.debug("rotation:{} received:{}", (Object)(++rotations), (Object)(received += this.doRead(endpoint, newBufs)));
            }
            catch (NoBytesAvailable no) {
                if (received == 0L) {
                    newBufs.removeFirst();
                    if (!newBufs.isEmpty()) {
                        newBufs.forEach(b -> this.returns.accept(b.reInit()));
                    }
                    LOGGER.debug("returning null");
                    return null;
                }
                Thread.onSpinWait();
                if (rotations > 1000000) {
                    throw new IOException("incomplete bytes in channel");
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new IOException(ie);
                }
            }
        }
        newBufs.removeFirst();
        if (newBufs.isEmpty()) {
            this.current.stream().findFirst().get().position(this.readTo).limit(this.readTo + len);
            TCReference ref = this.current.duplicate();
            this.readTo += len;
            LOGGER.debug("returning from read socket read with no new buffers: {}", (Object)ref.available());
            return ref;
        }
        this.current.stream().findFirst().get().limit(this.readBuffer.limit());
        TCByteBuffer last = newBufs.removeLast();
        int built = this.current.stream().findFirst().get().position(this.readTo).remaining();
        for (TCByteBuffer b2 : newBufs) {
            b2.flip();
            built += b2.remaining();
        }
        TCReference lastRef = this.createCompleteReference(last);
        int lastLim = lastRef.stream().findFirst().get().position(0).limit(len - built).limit();
        try {
            TCReference newRefs = TCReferenceSupport.createReference(newBufs, this.returns);
            try {
                TCReference retRef = TCReferenceSupport.createAggregateReference(this.current, newRefs, lastRef);
                Assert.assertEquals(retRef.available(), (long)len);
                LOGGER.debug("returning from socket read with new buffers: {}", (Object)retRef.available());
                TCReference tCReference = retRef;
                if (newRefs != null) {
                    newRefs.close();
                }
                return tCReference;
            }
            catch (Throwable throwable) {
                if (newRefs != null) {
                    try {
                        newRefs.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            this.replaceCurrent(last, lastRef, lastLim);
        }
    }

    private void replaceCurrent(TCByteBuffer raw, TCReference ref, int pos) {
        LOGGER.debug("replacing: {} {} with: {} {}", new Object[]{this.readBuffer, this.readTo, raw, pos});
        if (raw == this.readBuffer) {
            Assert.fail();
        }
        this.readBuffer = raw;
        if (this.current != null) {
            this.current.close();
        }
        this.current = ref;
        this.readTo = pos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TCReference createCompleteReference(TCByteBuffer buffer) {
        LOGGER.debug("creating complete ref: {} {}", (Object)buffer, (Object)this.readTo);
        int pos = buffer.position();
        Assert.assertEquals(buffer.limit(), buffer.capacity());
        try {
            TCReference tCReference = TCReferenceSupport.createReference(this.returns, buffer.clear());
            return tCReference;
        }
        finally {
            buffer.position(pos);
        }
    }

    private static void returnByteBuffers(List<TCByteBuffer> dest, ByteBuffer[] raw) {
        for (int x = 0; x < raw.length; ++x) {
            dest.get(x).returnNioBuffer(raw[x]);
        }
    }

    private static ByteBuffer[] extractByteBuffers(List<TCByteBuffer> dest) {
        return (ByteBuffer[])dest.stream().map(TCByteBuffer::getNioBuffer).toArray(ByteBuffer[]::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private long doRead(SocketEndpoint endpoint, List<TCByteBuffer> dest) throws IOException {
        remain = dest.stream().mapToInt((ToIntFunction<TCByteBuffer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)I, remaining(), (Lcom/tc/bytes/TCByteBuffer;)I)()).asLongStream().sum();
        nioBytes = TCSocketEndpointReader.extractByteBuffers(dest);
        try {
            switch (1.$SwitchMap$com$tc$net$core$SocketEndpoint$ResultType[endpoint.readTo(nioBytes).ordinal()]) {
                case 1: {
                    throw new EOFException();
                }
                case 2: {
                    dest.forEach((Consumer<TCByteBuffer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$doRead$5(com.tc.bytes.TCByteBuffer ), (Lcom/tc/bytes/TCByteBuffer;)V)());
                    dest.add(this.allocator.apply(TCByteBufferFactory.getFixedBufferSize()));
                    ** break;
lbl12:
                    // 1 sources

                    break;
                }
                case 3: 
                case 4: {
                    ** break;
lbl15:
                    // 1 sources

                    break;
                }
                case 5: {
                    throw new NoBytesAvailable();
                }
                ** default:
lbl19:
                // 1 sources

                break;
            }
        }
        finally {
            remain -= dest.stream().mapToInt((ToIntFunction<TCByteBuffer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)I, remaining(), (Lcom/tc/bytes/TCByteBuffer;)I)()).asLongStream().sum();
            TCSocketEndpointReader.returnByteBuffers(dest, nioBytes);
        }
        TCSocketEndpointReader.LOGGER.debug("read from socket: {}", (Object)remain);
        return remain;
    }

    @Override
    public void close() {
        if (this.current != null) {
            this.current.close();
        }
    }

    private static /* synthetic */ void lambda$doRead$5(TCByteBuffer b) {
        b.limit(b.position());
    }

    private static class NoBytesAvailable
    extends IOException {
        private NoBytesAvailable() {
        }
    }
}

