/*
 * Decompiled with CFR 0.152.
 */
package com.tc.bytes;

import com.tc.bytes.TCByteBuffer;
import com.tc.bytes.TCReference;
import com.tc.util.Assert;
import com.tc.util.concurrent.SetOnceFlag;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCReferenceSupport {
    private final Consumer<TCByteBuffer> returns;
    private final Collection<TCByteBuffer> items;
    private final AtomicInteger referenceCount = new AtomicInteger();
    private final MemoryTracker track;
    private static final Logger LOGGER = LoggerFactory.getLogger(TCReferenceSupport.class);
    private static final Set<TCReferenceSupport> COMMITTED_REFERENCES = ConcurrentHashMap.newKeySet();
    private static volatile boolean TRACK_REFERENCES;

    private TCReferenceSupport(Collection<TCByteBuffer> tracked, Consumer<TCByteBuffer> returns) {
        this.items = tracked;
        this.returns = returns;
        this.track = TRACK_REFERENCES ? new MemoryTracker() : null;
    }

    public static void startMonitoringReferences() {
        TRACK_REFERENCES = true;
    }

    public static void stopMonitoringReferences() {
        TRACK_REFERENCES = false;
        COMMITTED_REFERENCES.clear();
    }

    public static int checkReferences() {
        return COMMITTED_REFERENCES.stream().mapToInt(TCReferenceSupport::gc).sum();
    }

    public static TCReference createReference(Collection<TCByteBuffer> tracked, Consumer<TCByteBuffer> returns) {
        if (returns == null) {
            returns = c -> {};
        }
        return new TCReferenceSupport(tracked, returns).reference();
    }

    public static TCReference createReference(Consumer<TCByteBuffer> returns, TCByteBuffer ... tracked) {
        if (returns == null) {
            returns = c -> {};
        }
        return new TCReferenceSupport(Arrays.asList(tracked), returns).reference();
    }

    private void reclaim() {
        Assert.assertTrue(this.referenceCount.get() == 0);
        for (TCByteBuffer buf : this.items) {
            this.returns.accept(buf.reInit());
        }
        COMMITTED_REFERENCES.remove(this);
    }

    private int gc() {
        if (this.track != null) {
            return this.track.gc();
        }
        return 0;
    }

    public static TCReference createGCReference(Collection<TCByteBuffer> tracked) {
        return new GCRef(tracked);
    }

    public static TCReference createGCReference(TCByteBuffer ... tracked) {
        return TCReferenceSupport.createGCReference(Arrays.asList(tracked));
    }

    public static TCReference createAggregateReference(Collection<TCReference> tracked) {
        return new RefRef(tracked);
    }

    public static TCReference createAggregateReference(TCReference ... tracked) {
        return TCReferenceSupport.createAggregateReference(Arrays.asList(tracked));
    }

    private Ref reference() {
        if (this.track != null) {
            COMMITTED_REFERENCES.add(this);
        }
        return new Ref(this.items, TCByteBuffer::asReadOnlyBuffer);
    }

    private static <T> Collector<? super T, ?, List<T>> toUnmodifiableList() {
        return Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList);
    }

    private class MemoryTracker {
        private final Map<Reference<? extends TCReference>, Exception> outRefs = new ConcurrentHashMap<Reference<? extends TCReference>, Exception>();
        private final ReferenceQueue<TCReference> gcRefs = new ReferenceQueue();

        private MemoryTracker() {
        }

        private Reference<TCReference> startTracking(TCReference ref) {
            PhantomReference<TCReference> tracker = new PhantomReference<TCReference>(ref, this.gcRefs);
            Assert.assertNull(this.outRefs.put(tracker, new Exception(ref.toString())));
            return tracker;
        }

        private void stopTracking(Reference<TCReference> ref) {
            if (ref != null) {
                Assert.assertNotNull(this.outRefs.remove(ref));
            }
        }

        private int gc() {
            Reference<TCReference> next = this.gcRefs.poll();
            int count = 0;
            while (next != null) {
                Exception stack = this.outRefs.remove(next);
                Assert.assertNotNull(stack);
                LOGGER.warn("memory reference found that was not properly closed for {}. ", (Object)stack.getMessage(), (Object)stack);
                if (TCReferenceSupport.this.referenceCount.decrementAndGet() == 0) {
                    TCReferenceSupport.this.reclaim();
                }
                next = this.gcRefs.poll();
                ++count;
            }
            return count;
        }
    }

    private class Ref
    implements TCReference {
        private final List<TCByteBuffer> localItems;
        private final Reference<TCReference> tracker;
        private final SetOnceFlag closed = new SetOnceFlag();

        Ref(Collection<TCByteBuffer> localItems, Function<TCByteBuffer, TCByteBuffer> mapper) {
            TCReferenceSupport.this.referenceCount.getAndIncrement();
            if (localItems.isEmpty()) {
                this.localItems = Collections.emptyList();
                this.tracker = null;
            } else {
                this.localItems = localItems.stream().map(mapper).filter(TCByteBuffer::hasRemaining).collect(TCReferenceSupport.toUnmodifiableList());
                this.tracker = TCReferenceSupport.this.track == null ? null : TCReferenceSupport.this.track.startTracking(this);
            }
        }

        @Override
        public void close() {
            if (this.closed.attemptSet()) {
                if (TCReferenceSupport.this.track != null) {
                    TCReferenceSupport.this.track.stopTracking(this.tracker);
                }
                if (TCReferenceSupport.this.referenceCount.decrementAndGet() == 0) {
                    TCReferenceSupport.this.reclaim();
                }
            }
        }

        @Override
        public Iterator<TCByteBuffer> iterator() {
            this.checkClosed();
            return this.localItems.iterator();
        }

        @Override
        public ByteBuffer[] toByteBufferArray() {
            ByteBuffer[] raw = new ByteBuffer[this.localItems.size()];
            for (int i = 0; i < raw.length; ++i) {
                raw[i] = this.localItems.get(i).getNioBuffer();
            }
            return raw;
        }

        @Override
        public TCByteBuffer[] toArray() {
            return (TCByteBuffer[])this.localItems.toArray(TCByteBuffer[]::new);
        }

        private void checkClosed() {
            if (this.closed.isSet()) {
                throw new IllegalStateException("reference is closed");
            }
        }

        @Override
        public Ref duplicate() {
            this.checkClosed();
            return new Ref(this.localItems, TCByteBuffer::slice);
        }

        public String toString() {
            return this.localItems.stream().map(Object::toString).collect(Collectors.joining(",", System.identityHashCode(this) + "@", ""));
        }
    }

    private static class GCRef
    implements TCReference {
        private final List<TCByteBuffer> buffers;

        public GCRef(Collection<TCByteBuffer> buffers) {
            switch (buffers.size()) {
                case 0: {
                    this.buffers = Collections.emptyList();
                    break;
                }
                case 1: {
                    this.buffers = Collections.singletonList(buffers.iterator().next().slice());
                    break;
                }
                default: {
                    this.buffers = buffers.stream().filter(TCByteBuffer::hasRemaining).map(TCByteBuffer::slice).collect(Collectors.toList());
                }
            }
        }

        @Override
        public TCReference duplicate() {
            return new GCRef(this.buffers);
        }

        @Override
        public void close() {
        }

        @Override
        public ByteBuffer[] toByteBufferArray() {
            ByteBuffer[] raw = new ByteBuffer[this.buffers.size()];
            for (int x = 0; x < raw.length; ++x) {
                raw[x] = this.buffers.get(x).getNioBuffer();
            }
            return raw;
        }

        @Override
        public TCByteBuffer[] toArray() {
            return (TCByteBuffer[])this.buffers.toArray(TCByteBuffer[]::new);
        }

        @Override
        public Iterator<TCByteBuffer> iterator() {
            return this.buffers.iterator();
        }
    }

    private static class RefRef
    implements TCReference {
        private final List<TCReference> localItems;

        RefRef(Collection<TCReference> run) {
            switch (run.size()) {
                case 0: {
                    this.localItems = Collections.emptyList();
                    break;
                }
                case 1: {
                    this.localItems = Collections.singletonList(run.iterator().next().duplicate());
                    break;
                }
                default: {
                    this.localItems = run.stream().map(TCReference::duplicate).collect(TCReferenceSupport.toUnmodifiableList());
                }
            }
        }

        @Override
        public TCReference duplicate() {
            return new RefRef(this.localItems);
        }

        @Override
        public void close() {
            this.localItems.forEach(TCReference::close);
        }

        @Override
        public Iterator<TCByteBuffer> iterator() {
            return this.localItems.stream().flatMap(r -> StreamSupport.stream(r.spliterator(), false)).iterator();
        }
    }
}

