/*
 * Decompiled with CFR 0.152.
 */
package com.tc.async.impl;

import com.tc.async.api.MultiThreadedEventContext;
import com.tc.async.api.Sink;
import com.tc.async.api.Source;
import com.tc.async.impl.EventCreator;
import com.tc.async.impl.MultiStageQueueImpl;
import com.tc.async.impl.SingletonStageQueueImpl;
import com.tc.logging.TCLoggerProvider;
import com.tc.util.concurrent.QueueFactory;
import java.util.Map;

public interface StageQueue<EC>
extends Sink<EC> {
    public static final StageQueueFactory FACTORY = new StageQueueFactory();

    public Source getSource(int var1);

    public void close();

    public String toString();

    public Map<String, ?> getState();

    public void enableAdditionalStatistics(boolean var1);

    public static class StageQueueFactory {
        public static <C> StageQueue<C> factory(int queueCount, QueueFactory queueFactory, Class<C> type, EventCreator<C> creator, TCLoggerProvider loggerProvider, String stageName, int queueSize) {
            if (!MultiThreadedEventContext.class.isAssignableFrom(type)) {
                return new SingletonStageQueueImpl<C>(queueFactory, type, creator, loggerProvider, stageName, queueSize);
            }
            return new MultiStageQueueImpl<C>(queueCount, queueFactory, type, creator, loggerProvider, stageName, queueSize);
        }
    }
}

