/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.lease;

import java.io.Closeable;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.connection.Connection;
import org.terracotta.lease.Lease;
import org.terracotta.lease.LeaseMaintainer;
import org.terracotta.lease.NullLease;
import org.terracotta.lease.TimeSource;

public class LeaseExpiryConnectionKillingThread
extends Thread
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(LeaseExpiryConnectionKillingThread.class);
    private final LeaseMaintainer leaseMaintainer;
    private final Connection connection;
    private final TimeSource timeSource;
    private volatile boolean shutdown = false;

    LeaseExpiryConnectionKillingThread(LeaseMaintainer leaseMaintainer, Connection connection, TimeSource timeSource) {
        this.leaseMaintainer = leaseMaintainer;
        this.connection = connection;
        this.timeSource = timeSource;
        this.setName("LeaseExpiryConnectionKillingThread");
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.shutdown) {
            try {
                boolean validLease;
                Lease lease = this.leaseMaintainer.getCurrentLease();
                if (!(lease instanceof NullLease) && !(validLease = lease.isValidAndContiguous(lease))) {
                    try {
                        LOGGER.info("Lease lost, so closing connection to server: " + lease);
                        this.connection.close();
                    }
                    catch (IOException e) {
                        LOGGER.error("Closing connection, due to lease expiry, caused an error", (Throwable)e);
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                    return;
                }
                this.timeSource.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                if (!this.shutdown) continue;
                return;
            }
            finally {
                if (!this.shutdown) continue;
                return;
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.shutdown = true;
    }
}

