/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.messages;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.ehcache.clustered.common.internal.messages.ConcurrentEntityMessage;
import org.ehcache.clustered.common.internal.messages.EhcacheMessageType;
import org.ehcache.clustered.common.internal.messages.EhcacheOperationMessage;
import org.ehcache.clustered.common.internal.store.Chain;

public abstract class ServerStoreOpMessage
extends EhcacheOperationMessage {
    private ServerStoreOpMessage() {
    }

    public static class EnableEventListenerMessage
    extends ServerStoreOpMessage {
        private final boolean enable;

        public EnableEventListenerMessage(boolean enable) {
            this.enable = enable;
        }

        public boolean isEnable() {
            return this.enable;
        }

        @Override
        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.ENABLE_EVENT_LISTENER;
        }
    }

    public static class IteratorAdvanceMessage
    extends ServerStoreOpMessage {
        private final UUID id;
        private final int batchSize;

        public IteratorAdvanceMessage(UUID id, int batchSize) {
            this.id = id;
            this.batchSize = batchSize;
        }

        public UUID getIdentity() {
            return this.id;
        }

        public int getBatchSize() {
            return this.batchSize;
        }

        @Override
        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.ITERATOR_ADVANCE;
        }
    }

    public static class IteratorCloseMessage
    extends ServerStoreOpMessage {
        private final UUID id;

        public IteratorCloseMessage(UUID id) {
            this.id = id;
        }

        public UUID getIdentity() {
            return this.id;
        }

        @Override
        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.ITERATOR_CLOSE;
        }
    }

    public static class IteratorOpenMessage
    extends ServerStoreOpMessage {
        private final int batchSize;

        public IteratorOpenMessage(int batchSize) {
            this.batchSize = batchSize;
        }

        public int getBatchSize() {
            return this.batchSize;
        }

        @Override
        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.ITERATOR_OPEN;
        }
    }

    public static class UnlockMessage
    extends ServerStoreOpMessage {
        private final long hash;

        public UnlockMessage(long hash) {
            this.hash = hash;
        }

        public long getHash() {
            return this.hash;
        }

        @Override
        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.UNLOCK;
        }
    }

    public static class LockMessage
    extends ServerStoreOpMessage {
        private final long hash;

        public LockMessage(long hash) {
            this.hash = hash;
        }

        public long getHash() {
            return this.hash;
        }

        @Override
        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.LOCK;
        }
    }

    public static class ClearMessage
    extends ServerStoreOpMessage {
        @Override
        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.CLEAR;
        }
    }

    public static class ClientInvalidationAllAck
    extends ServerStoreOpMessage {
        private final int invalidationId;

        public ClientInvalidationAllAck(int invalidationId) {
            this.invalidationId = invalidationId;
        }

        @Override
        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.CLIENT_INVALIDATION_ALL_ACK;
        }

        public int getInvalidationId() {
            return this.invalidationId;
        }
    }

    public static class ClientInvalidationAck
    extends KeyBasedServerStoreOpMessage {
        private final int invalidationId;

        public ClientInvalidationAck(long key, int invalidationId) {
            super(key);
            this.invalidationId = invalidationId;
        }

        public int getInvalidationId() {
            return this.invalidationId;
        }

        @Override
        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.CLIENT_INVALIDATION_ACK;
        }
    }

    public static class ReplaceAtHeadMessage
    extends KeyBasedServerStoreOpMessage {
        private final Chain expect;
        private final Chain update;

        public ReplaceAtHeadMessage(long key, Chain expect, Chain update) {
            super(key);
            this.expect = expect;
            this.update = update;
        }

        @Override
        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.REPLACE;
        }

        public Chain getExpect() {
            return this.expect;
        }

        public Chain getUpdate() {
            return this.update;
        }
    }

    public static class InsertFullChainMessage
    extends KeyBasedServerStoreOpMessage {
        private final Chain chain;

        public InsertFullChainMessage(long key, Chain chain) {
            super(key);
            this.chain = chain;
        }

        @Override
        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.INSERT_FULL_CHAIN;
        }

        public Chain getChain() {
            return this.chain;
        }
    }

    public static class AppendMessage
    extends KeyBasedServerStoreOpMessage {
        private final ByteBuffer payload;

        public AppendMessage(long key, ByteBuffer payload) {
            super(key);
            this.payload = payload;
        }

        @Override
        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.APPEND;
        }

        public ByteBuffer getPayload() {
            return this.payload;
        }
    }

    public static class GetAndAppendMessage
    extends KeyBasedServerStoreOpMessage {
        private final ByteBuffer payload;

        public GetAndAppendMessage(long key, ByteBuffer payload) {
            super(key);
            this.payload = payload;
        }

        @Override
        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.GET_AND_APPEND;
        }

        public ByteBuffer getPayload() {
            return this.payload;
        }
    }

    public static class GetMessage
    extends KeyBasedServerStoreOpMessage {
        public GetMessage(long key) {
            super(key);
        }

        @Override
        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.GET_STORE;
        }
    }

    public static abstract class KeyBasedServerStoreOpMessage
    extends ServerStoreOpMessage
    implements ConcurrentEntityMessage {
        private final long key;

        KeyBasedServerStoreOpMessage(long key) {
            this.key = key;
        }

        public long getKey() {
            return this.key;
        }

        @Override
        public long concurrencyKey() {
            return this.key;
        }
    }
}

