/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.tcm;

import com.tc.bytes.TCByteBuffer;
import com.tc.bytes.TCByteBufferFactory;
import com.tc.bytes.TCReference;
import com.tc.bytes.TCReferenceSupport;
import com.tc.io.TCByteBufferInputStream;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.io.TCSerializable;
import com.tc.net.NodeID;
import com.tc.net.groups.NodeIDSerializer;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.NetworkRecall;
import com.tc.net.protocol.tcm.TCAction;
import com.tc.net.protocol.tcm.TCActionNetworkMessage;
import com.tc.net.protocol.tcm.TCActionNetworkMessageImpl;
import com.tc.net.protocol.tcm.TCMessageHeader;
import com.tc.net.protocol.tcm.TCMessageHeaderImpl;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.net.protocol.tcm.UnknownNameException;
import com.tc.util.AbstractIdentifier;
import com.tc.util.concurrent.SetOnceFlag;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TCActionImpl
implements TCAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(TCActionImpl.class);
    private final MessageMonitor monitor;
    private final SetOnceFlag processed = new SetOnceFlag();
    private final SetOnceFlag isSent = new SetOnceFlag();
    private final TCMessageType type;
    private final MessageChannel channel;
    private final boolean isOutgoing;
    private int nvCount;
    private final TCByteBufferOutputStream out;
    private final TCByteBufferInputStream bbis;
    private int messageVersion;

    protected TCActionImpl(MessageMonitor monitor, TCByteBufferOutputStream output, MessageChannel channel, TCMessageType type) {
        this.monitor = monitor;
        this.type = type;
        this.channel = channel;
        this.out = output;
        this.bbis = null;
        this.isOutgoing = true;
    }

    protected TCActionImpl(MessageMonitor monitor, MessageChannel channel, TCMessageHeader header, TCByteBufferInputStream data) {
        this.monitor = monitor;
        this.type = TCMessageType.getInstance(header.getMessageType());
        this.messageVersion = header.getMessageTypeVersion();
        this.bbis = data;
        this.out = null;
        this.channel = channel;
        this.isOutgoing = false;
    }

    @Override
    public TCMessageType getMessageType() {
        return this.type;
    }

    protected int getMessageVersion() {
        return this.messageVersion;
    }

    protected void setMessageVersion(int version) {
        this.messageVersion = version;
    }

    protected TCByteBufferInputStream getInputStream() {
        return this.bbis;
    }

    protected TCByteBufferOutputStream getOutputStream() {
        return this.out;
    }

    protected abstract void dehydrateValues();

    protected TCActionNetworkMessage convertToNetworkMessage() {
        return new TCActionNetworkMessageImpl(new TCMessageHeaderImpl(this.type), () -> this.getDataBuffers());
    }

    public TCReference getDataBuffers() {
        this.dehydrateValues();
        this.out.close();
        try (TCReference header = TCReferenceSupport.createGCReference(TCByteBufferFactory.getInstance(4).putInt(0, this.nvCount));){
            TCReference nvData = this.out.accessBuffers();
            try {
                TCReference tCReference = TCReferenceSupport.createAggregateReference(header, nvData);
                if (nvData != null) {
                    nvData.close();
                }
                return tCReference;
            }
            catch (Throwable throwable) {
                if (nvData != null) {
                    try {
                        nvData.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void hydrate() throws IOException, UnknownNameException {
        if (this.processed.attemptSet()) {
            try {
                int count = this.bbis.readInt();
                if (count < 0) {
                    throw new IOException("negative NV count: " + count);
                }
                for (int i = 0; i < count; ++i) {
                    byte name = this.bbis.readByte();
                    if (this.hydrateValue(name)) continue;
                    LOGGER.error(" Hydrate Error - " + this.toString());
                    throw new UnknownNameException(this.getClass(), name);
                }
            }
            finally {
                this.bbis.close();
            }
            this.monitor.newIncomingMessage(this);
        }
    }

    protected abstract boolean hydrateValue(byte var1) throws IOException;

    protected boolean getBooleanValue() throws IOException {
        return this.bbis.readBoolean();
    }

    protected byte getByteValue() throws IOException {
        return this.bbis.readByte();
    }

    protected char getCharValue() throws IOException {
        return this.bbis.readChar();
    }

    protected double getDoubleValue() throws IOException {
        return this.bbis.readDouble();
    }

    protected float getFloatValue() throws IOException {
        return this.bbis.readFloat();
    }

    protected int getIntValue() throws IOException {
        return this.bbis.readInt();
    }

    protected long getLongValue() throws IOException {
        return this.bbis.readLong();
    }

    protected short getShortValue() throws IOException {
        return this.bbis.readShort();
    }

    protected NodeID getNodeIDValue() throws IOException {
        return this.getObject(new NodeIDSerializer()).getNodeID();
    }

    protected <T extends TCSerializable<T>> T getObject(T target) throws IOException {
        return (T)((TCSerializable)target.deserializeFrom(this.bbis));
    }

    protected String getStringValue() throws IOException {
        return this.bbis.readString();
    }

    protected byte[] getBytesArray() throws IOException {
        int length = this.bbis.readInt();
        byte[] bytes = new byte[length];
        this.bbis.readFully(bytes);
        return bytes;
    }

    protected TCByteBuffer getByteBuffer() throws IOException {
        int length = this.bbis.readInt();
        return this.bbis.read(length);
    }

    protected void putNVPair(byte name, boolean value) {
        ++this.nvCount;
        this.out.write(name);
        this.out.writeBoolean(value);
    }

    protected void putNVPair(byte name, byte value) {
        ++this.nvCount;
        this.out.write(name);
        this.out.writeByte(value);
    }

    protected void putNVPair(byte name, char value) {
        ++this.nvCount;
        this.out.write(name);
        this.out.writeChar(value);
    }

    protected void putNVPair(byte name, double value) {
        ++this.nvCount;
        this.out.write(name);
        this.out.writeDouble(value);
    }

    protected void putNVPair(byte name, float value) {
        ++this.nvCount;
        this.out.write(name);
        this.out.writeFloat(value);
    }

    protected void putNVPair(byte name, int value) {
        ++this.nvCount;
        this.out.write(name);
        this.out.writeInt(value);
    }

    protected void putNVPair(byte name, long value) {
        ++this.nvCount;
        this.out.write(name);
        this.out.writeLong(value);
    }

    protected void putNVPair(byte name, short value) {
        ++this.nvCount;
        this.out.write(name);
        this.out.writeShort(value);
    }

    protected void putNVPair(byte name, String value) {
        ++this.nvCount;
        this.out.write(name);
        this.out.writeString(value);
    }

    protected void putNVPair(byte name, NodeID nodeID) {
        ++this.nvCount;
        this.out.write(name);
        new NodeIDSerializer(nodeID).serializeTo(this.out);
    }

    protected void putNVPair(byte name, TCSerializable<?> object) {
        ++this.nvCount;
        this.out.write(name);
        object.serializeTo(this.out);
    }

    protected void putNVPair(byte name, TCReference data) {
        ++this.nvCount;
        this.out.write(name);
        for (TCByteBuffer buf : data) {
            this.out.write(buf);
        }
    }

    protected void putNVPair(byte name, TCByteBuffer[] data) {
        ++this.nvCount;
        this.out.write(name);
        this.out.write(data);
    }

    protected void putNVPair(byte name, byte[] bytes) {
        ++this.nvCount;
        this.out.write(name);
        this.out.writeInt(bytes.length);
        this.out.write(bytes);
    }

    protected void putNVPair(byte name, AbstractIdentifier identifier) {
        ++this.nvCount;
        this.out.write(name);
        this.out.writeLong(identifier.toLong());
    }

    @Override
    public MessageChannel getChannel() {
        return this.channel;
    }

    @Override
    public NetworkRecall send() {
        block3: {
            if (this.isSent.attemptSet()) {
                TCActionNetworkMessage msg = this.convertToNetworkMessage();
                try {
                    this.basicSend(msg);
                    return msg::cancel;
                }
                catch (IOException ioe) {
                    if (!this.channel.isOpen()) break block3;
                    LOGGER.info("Message not sent: " + ioe.getMessage());
                }
            }
        }
        return null;
    }

    private void basicSend(TCActionNetworkMessage msg) throws IOException {
        this.channel.send(msg);
        this.monitor.newOutgoingMessage(this);
    }

    @Override
    public NodeID getSourceNodeID() {
        return this.isOutgoing ? this.channel.getLocalNodeID() : this.channel.getRemoteNodeID();
    }

    @Override
    public NodeID getDestinationNodeID() {
        return this.isOutgoing ? this.channel.getRemoteNodeID() : this.channel.getLocalNodeID();
    }

    @Override
    public int getMessageLength() {
        return 2 + (this.isOutgoing ? this.out.getBytesWritten() : this.bbis.getTotalLength());
    }
}

