/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.messages;

import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import org.ehcache.clustered.common.internal.messages.ClusterTierReconnectMessage;
import org.terracotta.runnel.Struct;
import org.terracotta.runnel.StructBuilder;
import org.terracotta.runnel.decoding.ArrayDecoder;
import org.terracotta.runnel.decoding.StructDecoder;
import org.terracotta.runnel.encoding.ArrayEncoder;
import org.terracotta.runnel.encoding.StructEncoder;

public class ReconnectMessageCodec {
    private static final String HASH_INVALIDATION_IN_PROGRESS_FIELD = "hashInvalidationInProgress";
    private static final String CLEAR_IN_PROGRESS_FIELD = "clearInProgress";
    private static final String LOCKS_HELD_FIELD = "locksHeld";
    private static final String EVENTS_ENABLED_FIELD = "eventsEnabled";
    private static final Struct CLUSTER_TIER_RECONNECT_MESSAGE_STRUCT = StructBuilder.newStructBuilder().int64s("hashInvalidationInProgress", 20).bool("clearInProgress", 30).int64s("locksHeld", 40).bool("eventsEnabled", 50).build();

    public byte[] encode(ClusterTierReconnectMessage reconnectMessage) {
        StructEncoder<Void> encoder = CLUSTER_TIER_RECONNECT_MESSAGE_STRUCT.encoder();
        ArrayEncoder<Long, StructEncoder<Void>> arrayEncoder = encoder.int64s(HASH_INVALIDATION_IN_PROGRESS_FIELD);
        reconnectMessage.getInvalidationsInProgress().forEach(arrayEncoder::value);
        encoder.bool(CLEAR_IN_PROGRESS_FIELD, reconnectMessage.isClearInProgress());
        ArrayEncoder<Long, StructEncoder<Void>> locksHeldEncoder = encoder.int64s(LOCKS_HELD_FIELD);
        reconnectMessage.getLocksHeld().forEach(locksHeldEncoder::value);
        encoder.bool(EVENTS_ENABLED_FIELD, reconnectMessage.isEventsEnabled());
        return encoder.encode().array();
    }

    public ClusterTierReconnectMessage decode(byte[] payload) {
        StructDecoder<Void> decoder = CLUSTER_TIER_RECONNECT_MESSAGE_STRUCT.decoder(ByteBuffer.wrap(payload));
        ArrayDecoder<Long, StructDecoder<Void>> arrayDecoder = decoder.int64s(HASH_INVALIDATION_IN_PROGRESS_FIELD);
        Set<Long> hashes = ReconnectMessageCodec.decodeLongs(arrayDecoder);
        Boolean clearInProgress = decoder.bool(CLEAR_IN_PROGRESS_FIELD);
        ArrayDecoder<Long, StructDecoder<Void>> locksHeldDecoder = decoder.int64s(LOCKS_HELD_FIELD);
        Set<Long> locks = ReconnectMessageCodec.decodeLongs(locksHeldDecoder);
        Boolean eventsEnabled = decoder.bool(EVENTS_ENABLED_FIELD);
        return new ClusterTierReconnectMessage(hashes, locks, clearInProgress != null ? clearInProgress : false, eventsEnabled != null ? eventsEnabled : false);
    }

    private static Set<Long> decodeLongs(ArrayDecoder<Long, StructDecoder<Void>> decoder) {
        HashSet<Long> longs;
        if (decoder != null) {
            longs = new HashSet(decoder.length());
            for (int i = 0; i < decoder.length(); ++i) {
                longs.add(decoder.value());
            }
        } else {
            longs = new HashSet<Long>(0);
        }
        return longs;
    }
}

